/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.model.EntityShape;
import com.oracle.bmc.dataintegration.requests.CreateEntityShapeRequest;
import com.oracle.bmc.dataintegration.responses.CreateEntityShapeResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEntityShapeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateEntityShapeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateEntityShapeRequest interceptRequest(CreateEntityShapeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateEntityShapeRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateEntityShapeDetails(), (String)"createEntityShapeDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId())).path("connections").path(HttpUtils.encodePathSegment((String)request.getConnectionKey())).path("schemas").path(HttpUtils.encodePathSegment((String)request.getSchemaResourceName())).path("entityShapes");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, CreateEntityShapeResponse> fromResponse() {
        Function<Response, CreateEntityShapeResponse> transformer = new Function<Response, CreateEntityShapeResponse>(){

            public CreateEntityShapeResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.CreateEntityShapeResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(EntityShape.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateEntityShapeResponse.Builder builder = CreateEntityShapeResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.entityShape((EntityShape)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateEntityShapeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

