/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.model.DataEntity;
import com.oracle.bmc.dataintegration.requests.GetDataEntityRequest;
import com.oracle.bmc.dataintegration.responses.GetDataEntityResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataEntityConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDataEntityConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDataEntityRequest interceptRequest(GetDataEntityRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDataEntityRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataEntityKey(), (String)"dataEntityKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId())).path("connections").path(HttpUtils.encodePathSegment((String)request.getConnectionKey())).path("schemas").path(HttpUtils.encodePathSegment((String)request.getSchemaResourceName())).path("dataEntities").path(HttpUtils.encodePathSegment((String)request.getDataEntityKey()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDataEntityResponse> fromResponse() {
        Function<Response, GetDataEntityResponse> transformer = new Function<Response, GetDataEntityResponse>(){

            public GetDataEntityResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.GetDataEntityResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DataEntity.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDataEntityResponse.Builder builder = GetDataEntityResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.dataEntity((DataEntity)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDataEntityResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

