/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CountStatisticSummary {
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="objectCount")
    private final Long objectCount;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().objectType(this.objectType).objectCount(this.objectCount);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Long getObjectCount() {
        return this.objectCount;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountStatisticSummary)) {
            return false;
        }
        CountStatisticSummary other = (CountStatisticSummary)o;
        Long this$objectCount = this.getObjectCount();
        Long other$objectCount = other.getObjectCount();
        if (this$objectCount == null ? other$objectCount != null : !((Object)this$objectCount).equals(other$objectCount)) {
            return false;
        }
        ObjectType this$objectType = this.getObjectType();
        ObjectType other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $objectCount = this.getObjectCount();
        result = result * 59 + ($objectCount == null ? 43 : ((Object)$objectCount).hashCode());
        ObjectType $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CountStatisticSummary(objectType=" + (Object)((Object)this.getObjectType()) + ", objectCount=" + this.getObjectCount() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"objectType", "objectCount"})
    @Deprecated
    public CountStatisticSummary(ObjectType objectType, Long objectCount) {
        this.objectType = objectType;
        this.objectCount = objectCount;
    }

    public static enum ObjectType {
        Project("PROJECT"),
        Folder("FOLDER"),
        DataFlow("DATA_FLOW"),
        DataAsset("DATA_ASSET"),
        Connection("CONNECTION"),
        Task("TASK"),
        Application("APPLICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ObjectType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ObjectType.class);
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="objectCount")
        private Long objectCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            this.__explicitlySet__.add("objectCount");
            return this;
        }

        public CountStatisticSummary build() {
            CountStatisticSummary __instance__ = new CountStatisticSummary(this.objectType, this.objectCount);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CountStatisticSummary o) {
            Builder copiedBuilder = this.objectType(o.getObjectType()).objectCount(o.getObjectCount());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CountStatisticSummary.Builder(objectType=" + (Object)((Object)this.objectType) + ", objectCount=" + this.objectCount + ")";
        }
    }
}

