/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromAdwc;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromAtp;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromJdbc;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromMySQL;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromObjectStorage;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromOracle;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=CreateConnectionDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateConnectionFromMySQL.class, name="MYSQL_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromJdbc.class, name="GENERIC_JDBC_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromAtp.class, name="ORACLE_ATP_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromAdwc.class, name="ORACLE_ADWC_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromOracle.class, name="ORACLEDB_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromObjectStorage.class, name="ORACLE_OBJECT_STORAGE_CONNECTION")})
@JsonFilter(value="explicitlySetFilter")
public class CreateConnectionDetails {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="connectionProperties")
    private final List<ConnectionProperty> connectionProperties;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConnectionDetails)) {
            return false;
        }
        CreateConnectionDetails other = (CreateConnectionDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<ConnectionProperty> this$connectionProperties = this.getConnectionProperties();
        List<ConnectionProperty> other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !((Object)this$connectionProperties).equals(other$connectionProperties)) {
            return false;
        }
        RegistryMetadata this$registryMetadata = this.getRegistryMetadata();
        RegistryMetadata other$registryMetadata = other.getRegistryMetadata();
        return !(this$registryMetadata == null ? other$registryMetadata != null : !((Object)this$registryMetadata).equals(other$registryMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConnectionDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<ConnectionProperty> $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : ((Object)$connectionProperties).hashCode());
        RegistryMetadata $registryMetadata = this.getRegistryMetadata();
        result = result * 59 + ($registryMetadata == null ? 43 : ((Object)$registryMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "CreateConnectionDetails(key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectStatus=" + this.getObjectStatus() + ", identifier=" + this.getIdentifier() + ", connectionProperties=" + this.getConnectionProperties() + ", registryMetadata=" + this.getRegistryMetadata() + ")";
    }

    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectStatus", "identifier", "connectionProperties", "registryMetadata"})
    @Deprecated
    protected CreateConnectionDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<ConnectionProperty> connectionProperties, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.connectionProperties = connectionProperties;
        this.registryMetadata = registryMetadata;
    }

    public static enum ModelType {
        OracleAdwcConnection("ORACLE_ADWC_CONNECTION"),
        OracleAtpConnection("ORACLE_ATP_CONNECTION"),
        OracleObjectStorageConnection("ORACLE_OBJECT_STORAGE_CONNECTION"),
        OracledbConnection("ORACLEDB_CONNECTION"),
        MysqlConnection("MYSQL_CONNECTION"),
        GenericJdbcConnection("GENERIC_JDBC_CONNECTION");

        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ModelType: " + key);
        }

        static {
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

