/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.DataEntity;
import com.oracle.bmc.dataintegration.model.ForeignKey;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Shape;
import com.oracle.bmc.dataintegration.model.TypeLibrary;
import com.oracle.bmc.dataintegration.model.UniqueKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DataEntityFromView
extends DataEntity {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="shapeId")
    private final String shapeId;
    @JsonProperty(value="types")
    private final TypeLibrary types;
    @JsonProperty(value="entityType")
    private final EntityType entityType;
    @JsonProperty(value="otherTypeLabel")
    private final String otherTypeLabel;
    @JsonProperty(value="uniqueKeys")
    private final List<UniqueKey> uniqueKeys;
    @JsonProperty(value="foreignKeys")
    private final List<ForeignKey> foreignKeys;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public DataEntityFromView(ObjectMetadata metadata, String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, String externalKey, Shape shape, String shapeId, TypeLibrary types, EntityType entityType, String otherTypeLabel, List<UniqueKey> uniqueKeys, List<ForeignKey> foreignKeys, String resourceName, Integer objectStatus, String identifier) {
        super(metadata);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.externalKey = externalKey;
        this.shape = shape;
        this.shapeId = shapeId;
        this.types = types;
        this.entityType = entityType;
        this.otherTypeLabel = otherTypeLabel;
        this.uniqueKeys = uniqueKeys;
        this.foreignKeys = foreignKeys;
        this.resourceName = resourceName;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).modelVersion(this.modelVersion).parentRef(this.parentRef).name(this.name).description(this.description).objectVersion(this.objectVersion).externalKey(this.externalKey).shape(this.shape).shapeId(this.shapeId).types(this.types).entityType(this.entityType).otherTypeLabel(this.otherTypeLabel).uniqueKeys(this.uniqueKeys).foreignKeys(this.foreignKeys).resourceName(this.resourceName).objectStatus(this.objectStatus).identifier(this.identifier);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getShapeId() {
        return this.shapeId;
    }

    public TypeLibrary getTypes() {
        return this.types;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getOtherTypeLabel() {
        return this.otherTypeLabel;
    }

    public List<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "DataEntityFromView(super=" + super.toString() + ", key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectVersion=" + this.getObjectVersion() + ", externalKey=" + this.getExternalKey() + ", shape=" + this.getShape() + ", shapeId=" + this.getShapeId() + ", types=" + this.getTypes() + ", entityType=" + (Object)((Object)this.getEntityType()) + ", otherTypeLabel=" + this.getOtherTypeLabel() + ", uniqueKeys=" + this.getUniqueKeys() + ", foreignKeys=" + this.getForeignKeys() + ", resourceName=" + this.getResourceName() + ", objectStatus=" + this.getObjectStatus() + ", identifier=" + this.getIdentifier() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEntityFromView)) {
            return false;
        }
        DataEntityFromView other = (DataEntityFromView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$externalKey = this.getExternalKey();
        String other$externalKey = other.getExternalKey();
        if (this$externalKey == null ? other$externalKey != null : !this$externalKey.equals(other$externalKey)) {
            return false;
        }
        Shape this$shape = this.getShape();
        Shape other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !((Object)this$shape).equals(other$shape)) {
            return false;
        }
        String this$shapeId = this.getShapeId();
        String other$shapeId = other.getShapeId();
        if (this$shapeId == null ? other$shapeId != null : !this$shapeId.equals(other$shapeId)) {
            return false;
        }
        TypeLibrary this$types = this.getTypes();
        TypeLibrary other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        String this$otherTypeLabel = this.getOtherTypeLabel();
        String other$otherTypeLabel = other.getOtherTypeLabel();
        if (this$otherTypeLabel == null ? other$otherTypeLabel != null : !this$otherTypeLabel.equals(other$otherTypeLabel)) {
            return false;
        }
        List<UniqueKey> this$uniqueKeys = this.getUniqueKeys();
        List<UniqueKey> other$uniqueKeys = other.getUniqueKeys();
        if (this$uniqueKeys == null ? other$uniqueKeys != null : !((Object)this$uniqueKeys).equals(other$uniqueKeys)) {
            return false;
        }
        List<ForeignKey> this$foreignKeys = this.getForeignKeys();
        List<ForeignKey> other$foreignKeys = other.getForeignKeys();
        if (this$foreignKeys == null ? other$foreignKeys != null : !((Object)this$foreignKeys).equals(other$foreignKeys)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataEntityFromView;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 43 : ((Object)$objectVersion).hashCode());
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $externalKey = this.getExternalKey();
        result = result * 59 + ($externalKey == null ? 43 : $externalKey.hashCode());
        Shape $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : ((Object)$shape).hashCode());
        String $shapeId = this.getShapeId();
        result = result * 59 + ($shapeId == null ? 43 : $shapeId.hashCode());
        TypeLibrary $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        String $otherTypeLabel = this.getOtherTypeLabel();
        result = result * 59 + ($otherTypeLabel == null ? 43 : $otherTypeLabel.hashCode());
        List<UniqueKey> $uniqueKeys = this.getUniqueKeys();
        result = result * 59 + ($uniqueKeys == null ? 43 : ((Object)$uniqueKeys).hashCode());
        List<ForeignKey> $foreignKeys = this.getForeignKeys();
        result = result * 59 + ($foreignKeys == null ? 43 : ((Object)$foreignKeys).hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum EntityType {
        Table("TABLE"),
        View("VIEW"),
        File("FILE"),
        Queue("QUEUE"),
        Stream("STREAM"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EntityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EntityType.class);
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="shapeId")
        private String shapeId;
        @JsonProperty(value="types")
        private TypeLibrary types;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonProperty(value="otherTypeLabel")
        private String otherTypeLabel;
        @JsonProperty(value="uniqueKeys")
        private List<UniqueKey> uniqueKeys;
        @JsonProperty(value="foreignKeys")
        private List<ForeignKey> foreignKeys;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeId(String shapeId) {
            this.shapeId = shapeId;
            this.__explicitlySet__.add("shapeId");
            return this;
        }

        public Builder types(TypeLibrary types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder otherTypeLabel(String otherTypeLabel) {
            this.otherTypeLabel = otherTypeLabel;
            this.__explicitlySet__.add("otherTypeLabel");
            return this;
        }

        public Builder uniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            this.__explicitlySet__.add("uniqueKeys");
            return this;
        }

        public Builder foreignKeys(List<ForeignKey> foreignKeys) {
            this.foreignKeys = foreignKeys;
            this.__explicitlySet__.add("foreignKeys");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public DataEntityFromView build() {
            DataEntityFromView __instance__ = new DataEntityFromView(this.metadata, this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.externalKey, this.shape, this.shapeId, this.types, this.entityType, this.otherTypeLabel, this.uniqueKeys, this.foreignKeys, this.resourceName, this.objectStatus, this.identifier);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DataEntityFromView o) {
            Builder copiedBuilder = this.metadata(o.getMetadata()).key(o.getKey()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).name(o.getName()).description(o.getDescription()).objectVersion(o.getObjectVersion()).externalKey(o.getExternalKey()).shape(o.getShape()).shapeId(o.getShapeId()).types(o.getTypes()).entityType(o.getEntityType()).otherTypeLabel(o.getOtherTypeLabel()).uniqueKeys(o.getUniqueKeys()).foreignKeys(o.getForeignKeys()).resourceName(o.getResourceName()).objectStatus(o.getObjectStatus()).identifier(o.getIdentifier());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DataEntityFromView.Builder(key=" + this.key + ", modelVersion=" + this.modelVersion + ", parentRef=" + this.parentRef + ", name=" + this.name + ", description=" + this.description + ", objectVersion=" + this.objectVersion + ", externalKey=" + this.externalKey + ", shape=" + this.shape + ", shapeId=" + this.shapeId + ", types=" + this.types + ", entityType=" + (Object)((Object)this.entityType) + ", otherTypeLabel=" + this.otherTypeLabel + ", uniqueKeys=" + this.uniqueKeys + ", foreignKeys=" + this.foreignKeys + ", resourceName=" + this.resourceName + ", objectStatus=" + this.objectStatus + ", identifier=" + this.identifier + ")";
        }
    }
}

