/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.Aggregator;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.Distinct;
import com.oracle.bmc.dataintegration.model.EndOperator;
import com.oracle.bmc.dataintegration.model.Filter;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Intersect;
import com.oracle.bmc.dataintegration.model.Joiner;
import com.oracle.bmc.dataintegration.model.MergeOperator;
import com.oracle.bmc.dataintegration.model.Minus;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Projection;
import com.oracle.bmc.dataintegration.model.SortOper;
import com.oracle.bmc.dataintegration.model.Source;
import com.oracle.bmc.dataintegration.model.StartOperator;
import com.oracle.bmc.dataintegration.model.Target;
import com.oracle.bmc.dataintegration.model.TaskOperator;
import com.oracle.bmc.dataintegration.model.Union;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=Operator.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Joiner.class, name="JOINER_OPERATOR"), @JsonSubTypes.Type(value=TaskOperator.class, name="TASK_OPERATOR"), @JsonSubTypes.Type(value=Aggregator.class, name="AGGREGATOR_OPERATOR"), @JsonSubTypes.Type(value=SortOper.class, name="SORT_OPERATOR"), @JsonSubTypes.Type(value=Projection.class, name="PROJECTION_OPERATOR"), @JsonSubTypes.Type(value=EndOperator.class, name="END_OPERATOR"), @JsonSubTypes.Type(value=Source.class, name="SOURCE_OPERATOR"), @JsonSubTypes.Type(value=Union.class, name="UNION_OPERATOR"), @JsonSubTypes.Type(value=Intersect.class, name="INTERSECT_OPERATOR"), @JsonSubTypes.Type(value=Target.class, name="TARGET_OPERATOR"), @JsonSubTypes.Type(value=Distinct.class, name="DISTINCT_OPERATOR"), @JsonSubTypes.Type(value=Filter.class, name="FILTER_OPERATOR"), @JsonSubTypes.Type(value=StartOperator.class, name="START_OPERATOR"), @JsonSubTypes.Type(value=MergeOperator.class, name="MERGE_OPERATOR"), @JsonSubTypes.Type(value=Minus.class, name="MINUS_OPERATOR")})
@JsonFilter(value="explicitlySetFilter")
public class Operator {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="inputPorts")
    private final List<InputPort> inputPorts;
    @JsonProperty(value="outputPorts")
    private final List<OutputPort> outputPorts;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="opConfigValues")
    private final ConfigValues opConfigValues;

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public List<InputPort> getInputPorts() {
        return this.inputPorts;
    }

    public List<OutputPort> getOutputPorts() {
        return this.outputPorts;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigValues getOpConfigValues() {
        return this.opConfigValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operator)) {
            return false;
        }
        Operator other = (Operator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<InputPort> this$inputPorts = this.getInputPorts();
        List<InputPort> other$inputPorts = other.getInputPorts();
        if (this$inputPorts == null ? other$inputPorts != null : !((Object)this$inputPorts).equals(other$inputPorts)) {
            return false;
        }
        List<OutputPort> this$outputPorts = this.getOutputPorts();
        List<OutputPort> other$outputPorts = other.getOutputPorts();
        if (this$outputPorts == null ? other$outputPorts != null : !((Object)this$outputPorts).equals(other$outputPorts)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        ConfigValues this$opConfigValues = this.getOpConfigValues();
        ConfigValues other$opConfigValues = other.getOpConfigValues();
        return !(this$opConfigValues == null ? other$opConfigValues != null : !((Object)this$opConfigValues).equals(other$opConfigValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Operator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 43 : ((Object)$objectVersion).hashCode());
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<InputPort> $inputPorts = this.getInputPorts();
        result = result * 59 + ($inputPorts == null ? 43 : ((Object)$inputPorts).hashCode());
        List<OutputPort> $outputPorts = this.getOutputPorts();
        result = result * 59 + ($outputPorts == null ? 43 : ((Object)$outputPorts).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        ConfigValues $opConfigValues = this.getOpConfigValues();
        result = result * 59 + ($opConfigValues == null ? 43 : ((Object)$opConfigValues).hashCode());
        return result;
    }

    public String toString() {
        return "Operator(key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectVersion=" + this.getObjectVersion() + ", inputPorts=" + this.getInputPorts() + ", outputPorts=" + this.getOutputPorts() + ", objectStatus=" + this.getObjectStatus() + ", identifier=" + this.getIdentifier() + ", parameters=" + this.getParameters() + ", opConfigValues=" + this.getOpConfigValues() + ")";
    }

    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "inputPorts", "outputPorts", "objectStatus", "identifier", "parameters", "opConfigValues"})
    @Deprecated
    protected Operator(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<OutputPort> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.parameters = parameters;
        this.opConfigValues = opConfigValues;
    }

    public static enum ModelType {
        SourceOperator("SOURCE_OPERATOR"),
        FilterOperator("FILTER_OPERATOR"),
        JoinerOperator("JOINER_OPERATOR"),
        AggregatorOperator("AGGREGATOR_OPERATOR"),
        ProjectionOperator("PROJECTION_OPERATOR"),
        TargetOperator("TARGET_OPERATOR"),
        DistinctOperator("DISTINCT_OPERATOR"),
        SortOperator("SORT_OPERATOR"),
        UnionOperator("UNION_OPERATOR"),
        IntersectOperator("INTERSECT_OPERATOR"),
        MinusOperator("MINUS_OPERATOR"),
        MergeOperator("MERGE_OPERATOR"),
        StartOperator("START_OPERATOR"),
        EndOperator("END_OPERATOR"),
        PipelineOperator("PIPELINE_OPERATOR"),
        RestOperator("REST_OPERATOR"),
        TaskOperator("TASK_OPERATOR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

