/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Parameter
extends TypedObject {
    @JsonProperty(value="type")
    private final BaseType type;
    @JsonProperty(value="defaultValue")
    private final Object defaultValue;
    @JsonProperty(value="rootObjectDefaultValue")
    private final Object rootObjectDefaultValue;
    @JsonProperty(value="isInput")
    private final Boolean isInput;
    @JsonProperty(value="isOutput")
    private final Boolean isOutput;
    @JsonProperty(value="outputAggregationType")
    private final OutputAggregationType outputAggregationType;
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Parameter(String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, Integer objectStatus, String name, String description, BaseType type, Object defaultValue, Object rootObjectDefaultValue, Boolean isInput, Boolean isOutput, OutputAggregationType outputAggregationType, String typeName) {
        super(key, modelVersion, parentRef, configValues, objectStatus, name, description);
        this.type = type;
        this.defaultValue = defaultValue;
        this.rootObjectDefaultValue = rootObjectDefaultValue;
        this.isInput = isInput;
        this.isOutput = isOutput;
        this.outputAggregationType = outputAggregationType;
        this.typeName = typeName;
    }

    public Builder toBuilder() {
        return new Builder().type(this.type).defaultValue(this.defaultValue).rootObjectDefaultValue(this.rootObjectDefaultValue).isInput(this.isInput).isOutput(this.isOutput).outputAggregationType(this.outputAggregationType).typeName(this.typeName);
    }

    public BaseType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getRootObjectDefaultValue() {
        return this.rootObjectDefaultValue;
    }

    public Boolean getIsInput() {
        return this.isInput;
    }

    public Boolean getIsOutput() {
        return this.isOutput;
    }

    public OutputAggregationType getOutputAggregationType() {
        return this.outputAggregationType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "Parameter(super=" + super.toString() + ", type=" + this.getType() + ", defaultValue=" + this.getDefaultValue() + ", rootObjectDefaultValue=" + this.getRootObjectDefaultValue() + ", isInput=" + this.getIsInput() + ", isOutput=" + this.getIsOutput() + ", outputAggregationType=" + (Object)((Object)this.getOutputAggregationType()) + ", typeName=" + this.getTypeName() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isInput = this.getIsInput();
        Boolean other$isInput = other.getIsInput();
        if (this$isInput == null ? other$isInput != null : !((Object)this$isInput).equals(other$isInput)) {
            return false;
        }
        Boolean this$isOutput = this.getIsOutput();
        Boolean other$isOutput = other.getIsOutput();
        if (this$isOutput == null ? other$isOutput != null : !((Object)this$isOutput).equals(other$isOutput)) {
            return false;
        }
        BaseType this$type = this.getType();
        BaseType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Object this$rootObjectDefaultValue = this.getRootObjectDefaultValue();
        Object other$rootObjectDefaultValue = other.getRootObjectDefaultValue();
        if (this$rootObjectDefaultValue == null ? other$rootObjectDefaultValue != null : !this$rootObjectDefaultValue.equals(other$rootObjectDefaultValue)) {
            return false;
        }
        OutputAggregationType this$outputAggregationType = this.getOutputAggregationType();
        OutputAggregationType other$outputAggregationType = other.getOutputAggregationType();
        if (this$outputAggregationType == null ? other$outputAggregationType != null : !((Object)((Object)this$outputAggregationType)).equals((Object)other$outputAggregationType)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isInput = this.getIsInput();
        result = result * 59 + ($isInput == null ? 43 : ((Object)$isInput).hashCode());
        Boolean $isOutput = this.getIsOutput();
        result = result * 59 + ($isOutput == null ? 43 : ((Object)$isOutput).hashCode());
        BaseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Object $rootObjectDefaultValue = this.getRootObjectDefaultValue();
        result = result * 59 + ($rootObjectDefaultValue == null ? 43 : $rootObjectDefaultValue.hashCode());
        OutputAggregationType $outputAggregationType = this.getOutputAggregationType();
        result = result * 59 + ($outputAggregationType == null ? 43 : ((Object)((Object)$outputAggregationType)).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum OutputAggregationType {
        Min("MIN"),
        Max("MAX"),
        Count("COUNT"),
        Sum("SUM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OutputAggregationType> map;

        private OutputAggregationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputAggregationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OutputAggregationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OutputAggregationType.class);
            map = new HashMap<String, OutputAggregationType>();
            for (OutputAggregationType v : OutputAggregationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private BaseType type;
        @JsonProperty(value="defaultValue")
        private Object defaultValue;
        @JsonProperty(value="rootObjectDefaultValue")
        private Object rootObjectDefaultValue;
        @JsonProperty(value="isInput")
        private Boolean isInput;
        @JsonProperty(value="isOutput")
        private Boolean isOutput;
        @JsonProperty(value="outputAggregationType")
        private OutputAggregationType outputAggregationType;
        @JsonProperty(value="typeName")
        private String typeName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder type(BaseType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder rootObjectDefaultValue(Object rootObjectDefaultValue) {
            this.rootObjectDefaultValue = rootObjectDefaultValue;
            this.__explicitlySet__.add("rootObjectDefaultValue");
            return this;
        }

        public Builder isInput(Boolean isInput) {
            this.isInput = isInput;
            this.__explicitlySet__.add("isInput");
            return this;
        }

        public Builder isOutput(Boolean isOutput) {
            this.isOutput = isOutput;
            this.__explicitlySet__.add("isOutput");
            return this;
        }

        public Builder outputAggregationType(OutputAggregationType outputAggregationType) {
            this.outputAggregationType = outputAggregationType;
            this.__explicitlySet__.add("outputAggregationType");
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            this.__explicitlySet__.add("typeName");
            return this;
        }

        public Parameter build() {
            Parameter __instance__ = new Parameter(this.key, this.modelVersion, this.parentRef, this.configValues, this.objectStatus, this.name, this.description, this.type, this.defaultValue, this.rootObjectDefaultValue, this.isInput, this.isOutput, this.outputAggregationType, this.typeName);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Parameter o) {
            Builder copiedBuilder = this.key(o.getKey()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).configValues(o.getConfigValues()).objectStatus(o.getObjectStatus()).name(o.getName()).description(o.getDescription()).type(o.getType()).defaultValue(o.getDefaultValue()).rootObjectDefaultValue(o.getRootObjectDefaultValue()).isInput(o.getIsInput()).isOutput(o.getIsOutput()).outputAggregationType(o.getOutputAggregationType()).typeName(o.getTypeName());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Parameter.Builder(type=" + this.type + ", defaultValue=" + this.defaultValue + ", rootObjectDefaultValue=" + this.rootObjectDefaultValue + ", isInput=" + this.isInput + ", isOutput=" + this.isOutput + ", outputAggregationType=" + (Object)((Object)this.outputAggregationType) + ", typeName=" + this.typeName + ")";
        }
    }
}

