/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StructuredType {
    @JsonProperty(value="schema")
    private final BaseType schema;
    @JsonProperty(value="dtType")
    private final DtType dtType;
    @JsonProperty(value="typeSystemName")
    private final String typeSystemName;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().schema(this.schema).dtType(this.dtType).typeSystemName(this.typeSystemName).configDefinition(this.configDefinition);
    }

    public BaseType getSchema() {
        return this.schema;
    }

    public DtType getDtType() {
        return this.dtType;
    }

    public String getTypeSystemName() {
        return this.typeSystemName;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructuredType)) {
            return false;
        }
        StructuredType other = (StructuredType)o;
        BaseType this$schema = this.getSchema();
        BaseType other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        DtType this$dtType = this.getDtType();
        DtType other$dtType = other.getDtType();
        if (this$dtType == null ? other$dtType != null : !((Object)((Object)this$dtType)).equals((Object)other$dtType)) {
            return false;
        }
        String this$typeSystemName = this.getTypeSystemName();
        String other$typeSystemName = other.getTypeSystemName();
        if (this$typeSystemName == null ? other$typeSystemName != null : !this$typeSystemName.equals(other$typeSystemName)) {
            return false;
        }
        ConfigDefinition this$configDefinition = this.getConfigDefinition();
        ConfigDefinition other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !((Object)this$configDefinition).equals(other$configDefinition)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseType $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        DtType $dtType = this.getDtType();
        result = result * 59 + ($dtType == null ? 43 : ((Object)((Object)$dtType)).hashCode());
        String $typeSystemName = this.getTypeSystemName();
        result = result * 59 + ($typeSystemName == null ? 43 : $typeSystemName.hashCode());
        ConfigDefinition $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : ((Object)$configDefinition).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "StructuredType(schema=" + this.getSchema() + ", dtType=" + (Object)((Object)this.getDtType()) + ", typeSystemName=" + this.getTypeSystemName() + ", configDefinition=" + this.getConfigDefinition() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"schema", "dtType", "typeSystemName", "configDefinition"})
    @Deprecated
    public StructuredType(BaseType schema, DtType dtType, String typeSystemName, ConfigDefinition configDefinition) {
        this.schema = schema;
        this.dtType = dtType;
        this.typeSystemName = typeSystemName;
        this.configDefinition = configDefinition;
    }

    public static enum DtType {
        Primitive("PRIMITIVE"),
        Structured("STRUCTURED");

        private final String value;
        private static Map<String, DtType> map;

        private DtType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DtType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DtType: " + key);
        }

        static {
            map = new HashMap<String, DtType>();
            for (DtType v : DtType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="schema")
        private BaseType schema;
        @JsonProperty(value="dtType")
        private DtType dtType;
        @JsonProperty(value="typeSystemName")
        private String typeSystemName;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder schema(BaseType schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public Builder dtType(DtType dtType) {
            this.dtType = dtType;
            this.__explicitlySet__.add("dtType");
            return this;
        }

        public Builder typeSystemName(String typeSystemName) {
            this.typeSystemName = typeSystemName;
            this.__explicitlySet__.add("typeSystemName");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public StructuredType build() {
            StructuredType __instance__ = new StructuredType(this.schema, this.dtType, this.typeSystemName, this.configDefinition);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(StructuredType o) {
            Builder copiedBuilder = this.schema(o.getSchema()).dtType(o.getDtType()).typeSystemName(o.getTypeSystemName()).configDefinition(o.getConfigDefinition());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "StructuredType.Builder(schema=" + this.schema + ", dtType=" + (Object)((Object)this.dtType) + ", typeSystemName=" + this.typeSystemName + ", configDefinition=" + this.configDefinition + ")";
        }
    }
}

