/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Task;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TaskOperator
extends Operator {
    @JsonProperty(value="retryAttempts")
    private final Integer retryAttempts;
    @JsonProperty(value="retryDelayUnit")
    private final RetryDelayUnit retryDelayUnit;
    @JsonProperty(value="retryDelay")
    private final Double retryDelay;
    @JsonProperty(value="expectedDuration")
    private final Double expectedDuration;
    @JsonProperty(value="expectedDurationUnit")
    private final ExpectedDurationUnit expectedDurationUnit;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="task")
    private final Task task;
    @JsonProperty(value="triggerRule")
    private final TriggerRule triggerRule;
    @JsonProperty(value="configProviderDelegate")
    private final ConfigProvider configProviderDelegate;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public TaskOperator(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<OutputPort> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, Integer retryAttempts, RetryDelayUnit retryDelayUnit, Double retryDelay, Double expectedDuration, ExpectedDurationUnit expectedDurationUnit, TaskType taskType, Task task, TriggerRule triggerRule, ConfigProvider configProviderDelegate) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.retryAttempts = retryAttempts;
        this.retryDelayUnit = retryDelayUnit;
        this.retryDelay = retryDelay;
        this.expectedDuration = expectedDuration;
        this.expectedDurationUnit = expectedDurationUnit;
        this.taskType = taskType;
        this.task = task;
        this.triggerRule = triggerRule;
        this.configProviderDelegate = configProviderDelegate;
    }

    public Builder toBuilder() {
        return new Builder().retryAttempts(this.retryAttempts).retryDelayUnit(this.retryDelayUnit).retryDelay(this.retryDelay).expectedDuration(this.expectedDuration).expectedDurationUnit(this.expectedDurationUnit).taskType(this.taskType).task(this.task).triggerRule(this.triggerRule).configProviderDelegate(this.configProviderDelegate);
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public RetryDelayUnit getRetryDelayUnit() {
        return this.retryDelayUnit;
    }

    public Double getRetryDelay() {
        return this.retryDelay;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public ExpectedDurationUnit getExpectedDurationUnit() {
        return this.expectedDurationUnit;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public Task getTask() {
        return this.task;
    }

    public TriggerRule getTriggerRule() {
        return this.triggerRule;
    }

    public ConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "TaskOperator(super=" + super.toString() + ", retryAttempts=" + this.getRetryAttempts() + ", retryDelayUnit=" + (Object)((Object)this.getRetryDelayUnit()) + ", retryDelay=" + this.getRetryDelay() + ", expectedDuration=" + this.getExpectedDuration() + ", expectedDurationUnit=" + (Object)((Object)this.getExpectedDurationUnit()) + ", taskType=" + (Object)((Object)this.getTaskType()) + ", task=" + this.getTask() + ", triggerRule=" + (Object)((Object)this.getTriggerRule()) + ", configProviderDelegate=" + this.getConfigProviderDelegate() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskOperator)) {
            return false;
        }
        TaskOperator other = (TaskOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$retryAttempts = this.getRetryAttempts();
        Integer other$retryAttempts = other.getRetryAttempts();
        if (this$retryAttempts == null ? other$retryAttempts != null : !((Object)this$retryAttempts).equals(other$retryAttempts)) {
            return false;
        }
        Double this$retryDelay = this.getRetryDelay();
        Double other$retryDelay = other.getRetryDelay();
        if (this$retryDelay == null ? other$retryDelay != null : !((Object)this$retryDelay).equals(other$retryDelay)) {
            return false;
        }
        Double this$expectedDuration = this.getExpectedDuration();
        Double other$expectedDuration = other.getExpectedDuration();
        if (this$expectedDuration == null ? other$expectedDuration != null : !((Object)this$expectedDuration).equals(other$expectedDuration)) {
            return false;
        }
        RetryDelayUnit this$retryDelayUnit = this.getRetryDelayUnit();
        RetryDelayUnit other$retryDelayUnit = other.getRetryDelayUnit();
        if (this$retryDelayUnit == null ? other$retryDelayUnit != null : !((Object)((Object)this$retryDelayUnit)).equals((Object)other$retryDelayUnit)) {
            return false;
        }
        ExpectedDurationUnit this$expectedDurationUnit = this.getExpectedDurationUnit();
        ExpectedDurationUnit other$expectedDurationUnit = other.getExpectedDurationUnit();
        if (this$expectedDurationUnit == null ? other$expectedDurationUnit != null : !((Object)((Object)this$expectedDurationUnit)).equals((Object)other$expectedDurationUnit)) {
            return false;
        }
        TaskType this$taskType = this.getTaskType();
        TaskType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        TriggerRule this$triggerRule = this.getTriggerRule();
        TriggerRule other$triggerRule = other.getTriggerRule();
        if (this$triggerRule == null ? other$triggerRule != null : !((Object)((Object)this$triggerRule)).equals((Object)other$triggerRule)) {
            return false;
        }
        ConfigProvider this$configProviderDelegate = this.getConfigProviderDelegate();
        ConfigProvider other$configProviderDelegate = other.getConfigProviderDelegate();
        if (this$configProviderDelegate == null ? other$configProviderDelegate != null : !((Object)this$configProviderDelegate).equals(other$configProviderDelegate)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TaskOperator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $retryAttempts = this.getRetryAttempts();
        result = result * 59 + ($retryAttempts == null ? 43 : ((Object)$retryAttempts).hashCode());
        Double $retryDelay = this.getRetryDelay();
        result = result * 59 + ($retryDelay == null ? 43 : ((Object)$retryDelay).hashCode());
        Double $expectedDuration = this.getExpectedDuration();
        result = result * 59 + ($expectedDuration == null ? 43 : ((Object)$expectedDuration).hashCode());
        RetryDelayUnit $retryDelayUnit = this.getRetryDelayUnit();
        result = result * 59 + ($retryDelayUnit == null ? 43 : ((Object)((Object)$retryDelayUnit)).hashCode());
        ExpectedDurationUnit $expectedDurationUnit = this.getExpectedDurationUnit();
        result = result * 59 + ($expectedDurationUnit == null ? 43 : ((Object)((Object)$expectedDurationUnit)).hashCode());
        TaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        TriggerRule $triggerRule = this.getTriggerRule();
        result = result * 59 + ($triggerRule == null ? 43 : ((Object)((Object)$triggerRule)).hashCode());
        ConfigProvider $configProviderDelegate = this.getConfigProviderDelegate();
        result = result * 59 + ($configProviderDelegate == null ? 43 : ((Object)$configProviderDelegate).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum TriggerRule {
        AllSuccess("ALL_SUCCESS"),
        AllFailed("ALL_FAILED"),
        AllComplete("ALL_COMPLETE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggerRule> map;

        private TriggerRule(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggerRule create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggerRule', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggerRule.class);
            map = new HashMap<String, TriggerRule>();
            for (TriggerRule v : TriggerRule.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TaskType {
        PipelineTask("PIPELINE_TASK"),
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExpectedDurationUnit {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedDurationUnit> map;

        private ExpectedDurationUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedDurationUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedDurationUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedDurationUnit.class);
            map = new HashMap<String, ExpectedDurationUnit>();
            for (ExpectedDurationUnit v : ExpectedDurationUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RetryDelayUnit {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RetryDelayUnit> map;

        private RetryDelayUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RetryDelayUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RetryDelayUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RetryDelayUnit.class);
            map = new HashMap<String, RetryDelayUnit>();
            for (RetryDelayUnit v : RetryDelayUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<OutputPort> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="retryAttempts")
        private Integer retryAttempts;
        @JsonProperty(value="retryDelayUnit")
        private RetryDelayUnit retryDelayUnit;
        @JsonProperty(value="retryDelay")
        private Double retryDelay;
        @JsonProperty(value="expectedDuration")
        private Double expectedDuration;
        @JsonProperty(value="expectedDurationUnit")
        private ExpectedDurationUnit expectedDurationUnit;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="task")
        private Task task;
        @JsonProperty(value="triggerRule")
        private TriggerRule triggerRule;
        @JsonProperty(value="configProviderDelegate")
        private ConfigProvider configProviderDelegate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<OutputPort> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder retryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
            this.__explicitlySet__.add("retryAttempts");
            return this;
        }

        public Builder retryDelayUnit(RetryDelayUnit retryDelayUnit) {
            this.retryDelayUnit = retryDelayUnit;
            this.__explicitlySet__.add("retryDelayUnit");
            return this;
        }

        public Builder retryDelay(Double retryDelay) {
            this.retryDelay = retryDelay;
            this.__explicitlySet__.add("retryDelay");
            return this;
        }

        public Builder expectedDuration(Double expectedDuration) {
            this.expectedDuration = expectedDuration;
            this.__explicitlySet__.add("expectedDuration");
            return this;
        }

        public Builder expectedDurationUnit(ExpectedDurationUnit expectedDurationUnit) {
            this.expectedDurationUnit = expectedDurationUnit;
            this.__explicitlySet__.add("expectedDurationUnit");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder task(Task task) {
            this.task = task;
            this.__explicitlySet__.add("task");
            return this;
        }

        public Builder triggerRule(TriggerRule triggerRule) {
            this.triggerRule = triggerRule;
            this.__explicitlySet__.add("triggerRule");
            return this;
        }

        public Builder configProviderDelegate(ConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public TaskOperator build() {
            TaskOperator __instance__ = new TaskOperator(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.retryAttempts, this.retryDelayUnit, this.retryDelay, this.expectedDuration, this.expectedDurationUnit, this.taskType, this.task, this.triggerRule, this.configProviderDelegate);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(TaskOperator o) {
            Builder copiedBuilder = this.key(o.getKey()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).name(o.getName()).description(o.getDescription()).objectVersion(o.getObjectVersion()).inputPorts(o.getInputPorts()).outputPorts(o.getOutputPorts()).objectStatus(o.getObjectStatus()).identifier(o.getIdentifier()).parameters(o.getParameters()).opConfigValues(o.getOpConfigValues()).retryAttempts(o.getRetryAttempts()).retryDelayUnit(o.getRetryDelayUnit()).retryDelay(o.getRetryDelay()).expectedDuration(o.getExpectedDuration()).expectedDurationUnit(o.getExpectedDurationUnit()).taskType(o.getTaskType()).task(o.getTask()).triggerRule(o.getTriggerRule()).configProviderDelegate(o.getConfigProviderDelegate());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "TaskOperator.Builder(retryAttempts=" + this.retryAttempts + ", retryDelayUnit=" + (Object)((Object)this.retryDelayUnit) + ", retryDelay=" + this.retryDelay + ", expectedDuration=" + this.expectedDuration + ", expectedDurationUnit=" + (Object)((Object)this.expectedDurationUnit) + ", taskType=" + (Object)((Object)this.taskType) + ", task=" + this.task + ", triggerRule=" + (Object)((Object)this.triggerRule) + ", configProviderDelegate=" + this.configProviderDelegate + ")";
        }
    }
}

