/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TaskSchedule;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskRun {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="configProvider")
    private final ConfigProvider configProvider;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="startTimeMillis")
    private final Long startTimeMillis;
    @JsonProperty(value="endTimeMillis")
    private final Long endTimeMillis;
    @JsonProperty(value="lastUpdated")
    private final Long lastUpdated;
    @JsonProperty(value="recordsWritten")
    private final Long recordsWritten;
    @JsonProperty(value="bytesProcessed")
    private final Long bytesProcessed;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="expectedDuration")
    private final Double expectedDuration;
    @JsonProperty(value="expectedDurationUnit")
    private final ExpectedDurationUnit expectedDurationUnit;
    @JsonProperty(value="taskKey")
    private final String taskKey;
    @JsonProperty(value="retryAttempt")
    private final Integer retryAttempt;
    @JsonProperty(value="taskSchedule")
    private final TaskSchedule taskSchedule;
    @JsonProperty(value="metrics")
    private final Map<String, Float> metrics;
    @JsonProperty(value="executionErrors")
    private final List<String> executionErrors;
    @JsonProperty(value="terminationErrors")
    private final List<String> terminationErrors;
    @JsonProperty(value="opcRequestId")
    private final String opcRequestId;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).modelType(this.modelType).modelVersion(this.modelVersion).parentRef(this.parentRef).name(this.name).description(this.description).objectVersion(this.objectVersion).configProvider(this.configProvider).status(this.status).startTimeMillis(this.startTimeMillis).endTimeMillis(this.endTimeMillis).lastUpdated(this.lastUpdated).recordsWritten(this.recordsWritten).bytesProcessed(this.bytesProcessed).errorMessage(this.errorMessage).expectedDuration(this.expectedDuration).expectedDurationUnit(this.expectedDurationUnit).taskKey(this.taskKey).retryAttempt(this.retryAttempt).taskSchedule(this.taskSchedule).metrics(this.metrics).executionErrors(this.executionErrors).terminationErrors(this.terminationErrors).opcRequestId(this.opcRequestId).objectStatus(this.objectStatus).taskType(this.taskType).identifier(this.identifier).metadata(this.metadata).keyMap(this.keyMap);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public Long getRecordsWritten() {
        return this.recordsWritten;
    }

    public Long getBytesProcessed() {
        return this.bytesProcessed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public ExpectedDurationUnit getExpectedDurationUnit() {
        return this.expectedDurationUnit;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public Integer getRetryAttempt() {
        return this.retryAttempt;
    }

    public TaskSchedule getTaskSchedule() {
        return this.taskSchedule;
    }

    public Map<String, Float> getMetrics() {
        return this.metrics;
    }

    public List<String> getExecutionErrors() {
        return this.executionErrors;
    }

    public List<String> getTerminationErrors() {
        return this.terminationErrors;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun)o;
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        Long this$startTimeMillis = this.getStartTimeMillis();
        Long other$startTimeMillis = other.getStartTimeMillis();
        if (this$startTimeMillis == null ? other$startTimeMillis != null : !((Object)this$startTimeMillis).equals(other$startTimeMillis)) {
            return false;
        }
        Long this$endTimeMillis = this.getEndTimeMillis();
        Long other$endTimeMillis = other.getEndTimeMillis();
        if (this$endTimeMillis == null ? other$endTimeMillis != null : !((Object)this$endTimeMillis).equals(other$endTimeMillis)) {
            return false;
        }
        Long this$lastUpdated = this.getLastUpdated();
        Long other$lastUpdated = other.getLastUpdated();
        if (this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated)) {
            return false;
        }
        Long this$recordsWritten = this.getRecordsWritten();
        Long other$recordsWritten = other.getRecordsWritten();
        if (this$recordsWritten == null ? other$recordsWritten != null : !((Object)this$recordsWritten).equals(other$recordsWritten)) {
            return false;
        }
        Long this$bytesProcessed = this.getBytesProcessed();
        Long other$bytesProcessed = other.getBytesProcessed();
        if (this$bytesProcessed == null ? other$bytesProcessed != null : !((Object)this$bytesProcessed).equals(other$bytesProcessed)) {
            return false;
        }
        Double this$expectedDuration = this.getExpectedDuration();
        Double other$expectedDuration = other.getExpectedDuration();
        if (this$expectedDuration == null ? other$expectedDuration != null : !((Object)this$expectedDuration).equals(other$expectedDuration)) {
            return false;
        }
        Integer this$retryAttempt = this.getRetryAttempt();
        Integer other$retryAttempt = other.getRetryAttempt();
        if (this$retryAttempt == null ? other$retryAttempt != null : !((Object)this$retryAttempt).equals(other$retryAttempt)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ConfigProvider this$configProvider = this.getConfigProvider();
        ConfigProvider other$configProvider = other.getConfigProvider();
        if (this$configProvider == null ? other$configProvider != null : !((Object)this$configProvider).equals(other$configProvider)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        ExpectedDurationUnit this$expectedDurationUnit = this.getExpectedDurationUnit();
        ExpectedDurationUnit other$expectedDurationUnit = other.getExpectedDurationUnit();
        if (this$expectedDurationUnit == null ? other$expectedDurationUnit != null : !((Object)((Object)this$expectedDurationUnit)).equals((Object)other$expectedDurationUnit)) {
            return false;
        }
        String this$taskKey = this.getTaskKey();
        String other$taskKey = other.getTaskKey();
        if (this$taskKey == null ? other$taskKey != null : !this$taskKey.equals(other$taskKey)) {
            return false;
        }
        TaskSchedule this$taskSchedule = this.getTaskSchedule();
        TaskSchedule other$taskSchedule = other.getTaskSchedule();
        if (this$taskSchedule == null ? other$taskSchedule != null : !((Object)this$taskSchedule).equals(other$taskSchedule)) {
            return false;
        }
        Map<String, Float> this$metrics = this.getMetrics();
        Map<String, Float> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        List<String> this$executionErrors = this.getExecutionErrors();
        List<String> other$executionErrors = other.getExecutionErrors();
        if (this$executionErrors == null ? other$executionErrors != null : !((Object)this$executionErrors).equals(other$executionErrors)) {
            return false;
        }
        List<String> this$terminationErrors = this.getTerminationErrors();
        List<String> other$terminationErrors = other.getTerminationErrors();
        if (this$terminationErrors == null ? other$terminationErrors != null : !((Object)this$terminationErrors).equals(other$terminationErrors)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        TaskType this$taskType = this.getTaskType();
        TaskType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        ObjectMetadata this$metadata = this.getMetadata();
        ObjectMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, String> this$keyMap = this.getKeyMap();
        Map<String, String> other$keyMap = other.getKeyMap();
        if (this$keyMap == null ? other$keyMap != null : !((Object)this$keyMap).equals(other$keyMap)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 43 : ((Object)$objectVersion).hashCode());
        Long $startTimeMillis = this.getStartTimeMillis();
        result = result * 59 + ($startTimeMillis == null ? 43 : ((Object)$startTimeMillis).hashCode());
        Long $endTimeMillis = this.getEndTimeMillis();
        result = result * 59 + ($endTimeMillis == null ? 43 : ((Object)$endTimeMillis).hashCode());
        Long $lastUpdated = this.getLastUpdated();
        result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
        Long $recordsWritten = this.getRecordsWritten();
        result = result * 59 + ($recordsWritten == null ? 43 : ((Object)$recordsWritten).hashCode());
        Long $bytesProcessed = this.getBytesProcessed();
        result = result * 59 + ($bytesProcessed == null ? 43 : ((Object)$bytesProcessed).hashCode());
        Double $expectedDuration = this.getExpectedDuration();
        result = result * 59 + ($expectedDuration == null ? 43 : ((Object)$expectedDuration).hashCode());
        Integer $retryAttempt = this.getRetryAttempt();
        result = result * 59 + ($retryAttempt == null ? 43 : ((Object)$retryAttempt).hashCode());
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ConfigProvider $configProvider = this.getConfigProvider();
        result = result * 59 + ($configProvider == null ? 43 : ((Object)$configProvider).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        ExpectedDurationUnit $expectedDurationUnit = this.getExpectedDurationUnit();
        result = result * 59 + ($expectedDurationUnit == null ? 43 : ((Object)((Object)$expectedDurationUnit)).hashCode());
        String $taskKey = this.getTaskKey();
        result = result * 59 + ($taskKey == null ? 43 : $taskKey.hashCode());
        TaskSchedule $taskSchedule = this.getTaskSchedule();
        result = result * 59 + ($taskSchedule == null ? 43 : ((Object)$taskSchedule).hashCode());
        Map<String, Float> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        List<String> $executionErrors = this.getExecutionErrors();
        result = result * 59 + ($executionErrors == null ? 43 : ((Object)$executionErrors).hashCode());
        List<String> $terminationErrors = this.getTerminationErrors();
        result = result * 59 + ($terminationErrors == null ? 43 : ((Object)$terminationErrors).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        TaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        ObjectMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, String> $keyMap = this.getKeyMap();
        result = result * 59 + ($keyMap == null ? 43 : ((Object)$keyMap).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "TaskRun(key=" + this.getKey() + ", modelType=" + this.getModelType() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectVersion=" + this.getObjectVersion() + ", configProvider=" + this.getConfigProvider() + ", status=" + (Object)((Object)this.getStatus()) + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ", lastUpdated=" + this.getLastUpdated() + ", recordsWritten=" + this.getRecordsWritten() + ", bytesProcessed=" + this.getBytesProcessed() + ", errorMessage=" + this.getErrorMessage() + ", expectedDuration=" + this.getExpectedDuration() + ", expectedDurationUnit=" + (Object)((Object)this.getExpectedDurationUnit()) + ", taskKey=" + this.getTaskKey() + ", retryAttempt=" + this.getRetryAttempt() + ", taskSchedule=" + this.getTaskSchedule() + ", metrics=" + this.getMetrics() + ", executionErrors=" + this.getExecutionErrors() + ", terminationErrors=" + this.getTerminationErrors() + ", opcRequestId=" + this.getOpcRequestId() + ", objectStatus=" + this.getObjectStatus() + ", taskType=" + (Object)((Object)this.getTaskType()) + ", identifier=" + this.getIdentifier() + ", metadata=" + this.getMetadata() + ", keyMap=" + this.getKeyMap() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "objectVersion", "configProvider", "status", "startTimeMillis", "endTimeMillis", "lastUpdated", "recordsWritten", "bytesProcessed", "errorMessage", "expectedDuration", "expectedDurationUnit", "taskKey", "retryAttempt", "taskSchedule", "metrics", "executionErrors", "terminationErrors", "opcRequestId", "objectStatus", "taskType", "identifier", "metadata", "keyMap"})
    @Deprecated
    public TaskRun(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, ConfigProvider configProvider, Status status, Long startTimeMillis, Long endTimeMillis, Long lastUpdated, Long recordsWritten, Long bytesProcessed, String errorMessage, Double expectedDuration, ExpectedDurationUnit expectedDurationUnit, String taskKey, Integer retryAttempt, TaskSchedule taskSchedule, Map<String, Float> metrics, List<String> executionErrors, List<String> terminationErrors, String opcRequestId, Integer objectStatus, TaskType taskType, String identifier, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.configProvider = configProvider;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.lastUpdated = lastUpdated;
        this.recordsWritten = recordsWritten;
        this.bytesProcessed = bytesProcessed;
        this.errorMessage = errorMessage;
        this.expectedDuration = expectedDuration;
        this.expectedDurationUnit = expectedDurationUnit;
        this.taskKey = taskKey;
        this.retryAttempt = retryAttempt;
        this.taskSchedule = taskSchedule;
        this.metrics = metrics;
        this.executionErrors = executionErrors;
        this.terminationErrors = terminationErrors;
        this.opcRequestId = opcRequestId;
        this.objectStatus = objectStatus;
        this.taskType = taskType;
        this.identifier = identifier;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public static enum TaskType {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExpectedDurationUnit {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedDurationUnit> map;

        private ExpectedDurationUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedDurationUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedDurationUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedDurationUnit.class);
            map = new HashMap<String, ExpectedDurationUnit>();
            for (ExpectedDurationUnit v : ExpectedDurationUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="configProvider")
        private ConfigProvider configProvider;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="startTimeMillis")
        private Long startTimeMillis;
        @JsonProperty(value="endTimeMillis")
        private Long endTimeMillis;
        @JsonProperty(value="lastUpdated")
        private Long lastUpdated;
        @JsonProperty(value="recordsWritten")
        private Long recordsWritten;
        @JsonProperty(value="bytesProcessed")
        private Long bytesProcessed;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="expectedDuration")
        private Double expectedDuration;
        @JsonProperty(value="expectedDurationUnit")
        private ExpectedDurationUnit expectedDurationUnit;
        @JsonProperty(value="taskKey")
        private String taskKey;
        @JsonProperty(value="retryAttempt")
        private Integer retryAttempt;
        @JsonProperty(value="taskSchedule")
        private TaskSchedule taskSchedule;
        @JsonProperty(value="metrics")
        private Map<String, Float> metrics;
        @JsonProperty(value="executionErrors")
        private List<String> executionErrors;
        @JsonProperty(value="terminationErrors")
        private List<String> terminationErrors;
        @JsonProperty(value="opcRequestId")
        private String opcRequestId;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder configProvider(ConfigProvider configProvider) {
            this.configProvider = configProvider;
            this.__explicitlySet__.add("configProvider");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.__explicitlySet__.add("startTimeMillis");
            return this;
        }

        public Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            this.__explicitlySet__.add("endTimeMillis");
            return this;
        }

        public Builder lastUpdated(Long lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.__explicitlySet__.add("lastUpdated");
            return this;
        }

        public Builder recordsWritten(Long recordsWritten) {
            this.recordsWritten = recordsWritten;
            this.__explicitlySet__.add("recordsWritten");
            return this;
        }

        public Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            this.__explicitlySet__.add("bytesProcessed");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder expectedDuration(Double expectedDuration) {
            this.expectedDuration = expectedDuration;
            this.__explicitlySet__.add("expectedDuration");
            return this;
        }

        public Builder expectedDurationUnit(ExpectedDurationUnit expectedDurationUnit) {
            this.expectedDurationUnit = expectedDurationUnit;
            this.__explicitlySet__.add("expectedDurationUnit");
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            this.__explicitlySet__.add("taskKey");
            return this;
        }

        public Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            this.__explicitlySet__.add("retryAttempt");
            return this;
        }

        public Builder taskSchedule(TaskSchedule taskSchedule) {
            this.taskSchedule = taskSchedule;
            this.__explicitlySet__.add("taskSchedule");
            return this;
        }

        public Builder metrics(Map<String, Float> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder executionErrors(List<String> executionErrors) {
            this.executionErrors = executionErrors;
            this.__explicitlySet__.add("executionErrors");
            return this;
        }

        public Builder terminationErrors(List<String> terminationErrors) {
            this.terminationErrors = terminationErrors;
            this.__explicitlySet__.add("terminationErrors");
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            this.__explicitlySet__.add("opcRequestId");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public TaskRun build() {
            TaskRun __instance__ = new TaskRun(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.configProvider, this.status, this.startTimeMillis, this.endTimeMillis, this.lastUpdated, this.recordsWritten, this.bytesProcessed, this.errorMessage, this.expectedDuration, this.expectedDurationUnit, this.taskKey, this.retryAttempt, this.taskSchedule, this.metrics, this.executionErrors, this.terminationErrors, this.opcRequestId, this.objectStatus, this.taskType, this.identifier, this.metadata, this.keyMap);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(TaskRun o) {
            Builder copiedBuilder = this.key(o.getKey()).modelType(o.getModelType()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).name(o.getName()).description(o.getDescription()).objectVersion(o.getObjectVersion()).configProvider(o.getConfigProvider()).status(o.getStatus()).startTimeMillis(o.getStartTimeMillis()).endTimeMillis(o.getEndTimeMillis()).lastUpdated(o.getLastUpdated()).recordsWritten(o.getRecordsWritten()).bytesProcessed(o.getBytesProcessed()).errorMessage(o.getErrorMessage()).expectedDuration(o.getExpectedDuration()).expectedDurationUnit(o.getExpectedDurationUnit()).taskKey(o.getTaskKey()).retryAttempt(o.getRetryAttempt()).taskSchedule(o.getTaskSchedule()).metrics(o.getMetrics()).executionErrors(o.getExecutionErrors()).terminationErrors(o.getTerminationErrors()).opcRequestId(o.getOpcRequestId()).objectStatus(o.getObjectStatus()).taskType(o.getTaskType()).identifier(o.getIdentifier()).metadata(o.getMetadata()).keyMap(o.getKeyMap());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "TaskRun.Builder(key=" + this.key + ", modelType=" + this.modelType + ", modelVersion=" + this.modelVersion + ", parentRef=" + this.parentRef + ", name=" + this.name + ", description=" + this.description + ", objectVersion=" + this.objectVersion + ", configProvider=" + this.configProvider + ", status=" + (Object)((Object)this.status) + ", startTimeMillis=" + this.startTimeMillis + ", endTimeMillis=" + this.endTimeMillis + ", lastUpdated=" + this.lastUpdated + ", recordsWritten=" + this.recordsWritten + ", bytesProcessed=" + this.bytesProcessed + ", errorMessage=" + this.errorMessage + ", expectedDuration=" + this.expectedDuration + ", expectedDurationUnit=" + (Object)((Object)this.expectedDurationUnit) + ", taskKey=" + this.taskKey + ", retryAttempt=" + this.retryAttempt + ", taskSchedule=" + this.taskSchedule + ", metrics=" + this.metrics + ", executionErrors=" + this.executionErrors + ", terminationErrors=" + this.terminationErrors + ", opcRequestId=" + this.opcRequestId + ", objectStatus=" + this.objectStatus + ", taskType=" + (Object)((Object)this.taskType) + ", identifier=" + this.identifier + ", metadata=" + this.metadata + ", keyMap=" + this.keyMap + ")";
        }
    }
}

