/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateApplicationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateApplicationRequest
extends BmcRequest<CreateApplicationDetails> {
    private String workspaceId;
    private CreateApplicationDetails createApplicationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateApplicationDetails getBody$() {
        return this.createApplicationDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createApplicationDetails", "opcRequestId", "opcRetryToken"})
    CreateApplicationRequest(String workspaceId, CreateApplicationDetails createApplicationDetails, String opcRequestId, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.createApplicationDetails = createApplicationDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateApplicationDetails getCreateApplicationDetails() {
        return this.createApplicationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateApplicationRequest, CreateApplicationDetails> {
        private String workspaceId;
        private CreateApplicationDetails createApplicationDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateApplicationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createApplicationDetails(o.getCreateApplicationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateApplicationRequest build() {
            CreateApplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateApplicationDetails body) {
            this.createApplicationDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createApplicationDetails(CreateApplicationDetails createApplicationDetails) {
            this.createApplicationDetails = createApplicationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateApplicationRequest buildWithoutInvocationCallback() {
            return new CreateApplicationRequest(this.workspaceId, this.createApplicationDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateApplicationRequest.Builder(workspaceId=" + this.workspaceId + ", createApplicationDetails=" + this.createApplicationDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

