/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateEntityShapeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateEntityShapeRequest
extends BmcRequest<CreateEntityShapeDetails> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private CreateEntityShapeDetails createEntityShapeDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    @InternalSdk
    public CreateEntityShapeDetails getBody$() {
        return this.createEntityShapeDetails;
    }

    @ConstructorProperties(value={"workspaceId", "connectionKey", "schemaResourceName", "createEntityShapeDetails", "opcRequestId", "opcRetryToken", "ifMatch"})
    CreateEntityShapeRequest(String workspaceId, String connectionKey, String schemaResourceName, CreateEntityShapeDetails createEntityShapeDetails, String opcRequestId, String opcRetryToken, String ifMatch) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.schemaResourceName = schemaResourceName;
        this.createEntityShapeDetails = createEntityShapeDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public CreateEntityShapeDetails getCreateEntityShapeDetails() {
        return this.createEntityShapeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateEntityShapeRequest, CreateEntityShapeDetails> {
        private String workspaceId;
        private String connectionKey;
        private String schemaResourceName;
        private CreateEntityShapeDetails createEntityShapeDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateEntityShapeRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.createEntityShapeDetails(o.getCreateEntityShapeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateEntityShapeRequest build() {
            CreateEntityShapeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateEntityShapeDetails body) {
            this.createEntityShapeDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder createEntityShapeDetails(CreateEntityShapeDetails createEntityShapeDetails) {
            this.createEntityShapeDetails = createEntityShapeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CreateEntityShapeRequest buildWithoutInvocationCallback() {
            return new CreateEntityShapeRequest(this.workspaceId, this.connectionKey, this.schemaResourceName, this.createEntityShapeDetails, this.opcRequestId, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "CreateEntityShapeRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", schemaResourceName=" + this.schemaResourceName + ", createEntityShapeDetails=" + this.createEntityShapeDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

