/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreatePipelineDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreatePipelineRequest
extends BmcRequest<CreatePipelineDetails> {
    private String workspaceId;
    private CreatePipelineDetails createPipelineDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public CreatePipelineDetails getBody$() {
        return this.createPipelineDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createPipelineDetails", "opcRetryToken", "opcRequestId"})
    CreatePipelineRequest(String workspaceId, CreatePipelineDetails createPipelineDetails, String opcRetryToken, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.createPipelineDetails = createPipelineDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreatePipelineDetails getCreatePipelineDetails() {
        return this.createPipelineDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePipelineRequest, CreatePipelineDetails> {
        private String workspaceId;
        private CreatePipelineDetails createPipelineDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePipelineRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createPipelineDetails(o.getCreatePipelineDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePipelineRequest build() {
            CreatePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePipelineDetails body) {
            this.createPipelineDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createPipelineDetails(CreatePipelineDetails createPipelineDetails) {
            this.createPipelineDetails = createPipelineDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreatePipelineRequest buildWithoutInvocationCallback() {
            return new CreatePipelineRequest(this.workspaceId, this.createPipelineDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreatePipelineRequest.Builder(workspaceId=" + this.workspaceId + ", createPipelineDetails=" + this.createPipelineDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

