/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateTaskDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTaskRequest
extends BmcRequest<CreateTaskDetails> {
    private String workspaceId;
    private CreateTaskDetails createTaskDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public CreateTaskDetails getBody$() {
        return this.createTaskDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createTaskDetails", "opcRetryToken", "opcRequestId"})
    CreateTaskRequest(String workspaceId, CreateTaskDetails createTaskDetails, String opcRetryToken, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.createTaskDetails = createTaskDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateTaskDetails getCreateTaskDetails() {
        return this.createTaskDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTaskRequest, CreateTaskDetails> {
        private String workspaceId;
        private CreateTaskDetails createTaskDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTaskRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createTaskDetails(o.getCreateTaskDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTaskRequest build() {
            CreateTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTaskDetails body) {
            this.createTaskDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createTaskDetails(CreateTaskDetails createTaskDetails) {
            this.createTaskDetails = createTaskDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateTaskRequest buildWithoutInvocationCallback() {
            return new CreateTaskRequest(this.workspaceId, this.createTaskDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateTaskRequest.Builder(workspaceId=" + this.workspaceId + ", createTaskDetails=" + this.createTaskDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

