/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateTaskRunDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTaskRunRequest
extends BmcRequest<CreateTaskRunDetails> {
    private String workspaceId;
    private String applicationKey;
    private CreateTaskRunDetails createTaskRunDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public CreateTaskRunDetails getBody$() {
        return this.createTaskRunDetails;
    }

    @ConstructorProperties(value={"workspaceId", "applicationKey", "createTaskRunDetails", "opcRetryToken", "opcRequestId"})
    CreateTaskRunRequest(String workspaceId, String applicationKey, CreateTaskRunDetails createTaskRunDetails, String opcRetryToken, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.createTaskRunDetails = createTaskRunDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public CreateTaskRunDetails getCreateTaskRunDetails() {
        return this.createTaskRunDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTaskRunRequest, CreateTaskRunDetails> {
        private String workspaceId;
        private String applicationKey;
        private CreateTaskRunDetails createTaskRunDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTaskRunRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.createTaskRunDetails(o.getCreateTaskRunDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTaskRunRequest build() {
            CreateTaskRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTaskRunDetails body) {
            this.createTaskRunDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder createTaskRunDetails(CreateTaskRunDetails createTaskRunDetails) {
            this.createTaskRunDetails = createTaskRunDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateTaskRunRequest buildWithoutInvocationCallback() {
            return new CreateTaskRunRequest(this.workspaceId, this.applicationKey, this.createTaskRunDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateTaskRunRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", createTaskRunDetails=" + this.createTaskRunDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

