/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConnectionValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionValidationKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "connectionValidationKey", "ifMatch", "opcRequestId"})
    DeleteConnectionValidationRequest(String workspaceId, String connectionValidationKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.connectionValidationKey = connectionValidationKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionValidationKey() {
        return this.connectionValidationKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConnectionValidationRequest, Void> {
        private String workspaceId;
        private String connectionValidationKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConnectionValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionValidationKey(o.getConnectionValidationKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConnectionValidationRequest build() {
            DeleteConnectionValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionValidationKey(String connectionValidationKey) {
            this.connectionValidationKey = connectionValidationKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteConnectionValidationRequest buildWithoutInvocationCallback() {
            return new DeleteConnectionValidationRequest(this.workspaceId, this.connectionValidationKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteConnectionValidationRequest.Builder(workspaceId=" + this.workspaceId + ", connectionValidationKey=" + this.connectionValidationKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

