/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDataAssetRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String dataAssetKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "dataAssetKey", "ifMatch", "opcRequestId"})
    DeleteDataAssetRequest(String workspaceId, String dataAssetKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.dataAssetKey = dataAssetKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDataAssetRequest, Void> {
        private String workspaceId;
        private String dataAssetKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDataAssetRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataAssetKey(o.getDataAssetKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDataAssetRequest build() {
            DeleteDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDataAssetRequest buildWithoutInvocationCallback() {
            return new DeleteDataAssetRequest(this.workspaceId, this.dataAssetKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDataAssetRequest.Builder(workspaceId=" + this.workspaceId + ", dataAssetKey=" + this.dataAssetKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

