/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDataFlowValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String dataFlowValidationKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "dataFlowValidationKey", "ifMatch", "opcRequestId"})
    DeleteDataFlowValidationRequest(String workspaceId, String dataFlowValidationKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.dataFlowValidationKey = dataFlowValidationKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataFlowValidationKey() {
        return this.dataFlowValidationKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDataFlowValidationRequest, Void> {
        private String workspaceId;
        private String dataFlowValidationKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDataFlowValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataFlowValidationKey(o.getDataFlowValidationKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDataFlowValidationRequest build() {
            DeleteDataFlowValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataFlowValidationKey(String dataFlowValidationKey) {
            this.dataFlowValidationKey = dataFlowValidationKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDataFlowValidationRequest buildWithoutInvocationCallback() {
            return new DeleteDataFlowValidationRequest(this.workspaceId, this.dataFlowValidationKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDataFlowValidationRequest.Builder(workspaceId=" + this.workspaceId + ", dataFlowValidationKey=" + this.dataFlowValidationKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

