/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteTaskValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskValidationKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "taskValidationKey", "ifMatch", "opcRequestId"})
    DeleteTaskValidationRequest(String workspaceId, String taskValidationKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.taskValidationKey = taskValidationKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskValidationKey() {
        return this.taskValidationKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTaskValidationRequest, Void> {
        private String workspaceId;
        private String taskValidationKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTaskValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskValidationKey(o.getTaskValidationKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTaskValidationRequest build() {
            DeleteTaskValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskValidationKey(String taskValidationKey) {
            this.taskValidationKey = taskValidationKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteTaskValidationRequest buildWithoutInvocationCallback() {
            return new DeleteTaskValidationRequest(this.workspaceId, this.taskValidationKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteTaskValidationRequest.Builder(workspaceId=" + this.workspaceId + ", taskValidationKey=" + this.taskValidationKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

