/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConnectionValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionValidationKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "connectionValidationKey", "opcRequestId"})
    GetConnectionValidationRequest(String workspaceId, String connectionValidationKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.connectionValidationKey = connectionValidationKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionValidationKey() {
        return this.connectionValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConnectionValidationRequest, Void> {
        private String workspaceId;
        private String connectionValidationKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectionValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionValidationKey(o.getConnectionValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectionValidationRequest build() {
            GetConnectionValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionValidationKey(String connectionValidationKey) {
            this.connectionValidationKey = connectionValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetConnectionValidationRequest buildWithoutInvocationCallback() {
            return new GetConnectionValidationRequest(this.workspaceId, this.connectionValidationKey, this.opcRequestId);
        }

        public String toString() {
            return "GetConnectionValidationRequest.Builder(workspaceId=" + this.workspaceId + ", connectionValidationKey=" + this.connectionValidationKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

