/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetCountStatisticRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String countStatisticKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "countStatisticKey", "opcRequestId"})
    GetCountStatisticRequest(String workspaceId, String countStatisticKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.countStatisticKey = countStatisticKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getCountStatisticKey() {
        return this.countStatisticKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCountStatisticRequest, Void> {
        private String workspaceId;
        private String countStatisticKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCountStatisticRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.countStatisticKey(o.getCountStatisticKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCountStatisticRequest build() {
            GetCountStatisticRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder countStatisticKey(String countStatisticKey) {
            this.countStatisticKey = countStatisticKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetCountStatisticRequest buildWithoutInvocationCallback() {
            return new GetCountStatisticRequest(this.workspaceId, this.countStatisticKey, this.opcRequestId);
        }

        public String toString() {
            return "GetCountStatisticRequest.Builder(workspaceId=" + this.workspaceId + ", countStatisticKey=" + this.countStatisticKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

