/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDataEntityRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private String dataEntityKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "connectionKey", "schemaResourceName", "dataEntityKey", "opcRequestId"})
    GetDataEntityRequest(String workspaceId, String connectionKey, String schemaResourceName, String dataEntityKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.schemaResourceName = schemaResourceName;
        this.dataEntityKey = dataEntityKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getDataEntityKey() {
        return this.dataEntityKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataEntityRequest, Void> {
        private String workspaceId;
        private String connectionKey;
        private String schemaResourceName;
        private String dataEntityKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataEntityRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.dataEntityKey(o.getDataEntityKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataEntityRequest build() {
            GetDataEntityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder dataEntityKey(String dataEntityKey) {
            this.dataEntityKey = dataEntityKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDataEntityRequest buildWithoutInvocationCallback() {
            return new GetDataEntityRequest(this.workspaceId, this.connectionKey, this.schemaResourceName, this.dataEntityKey, this.opcRequestId);
        }

        public String toString() {
            return "GetDataEntityRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", schemaResourceName=" + this.schemaResourceName + ", dataEntityKey=" + this.dataEntityKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

