/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDataFlowRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String dataFlowKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "dataFlowKey", "opcRequestId"})
    GetDataFlowRequest(String workspaceId, String dataFlowKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.dataFlowKey = dataFlowKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataFlowKey() {
        return this.dataFlowKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataFlowRequest, Void> {
        private String workspaceId;
        private String dataFlowKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataFlowRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataFlowKey(o.getDataFlowKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataFlowRequest build() {
            GetDataFlowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataFlowKey(String dataFlowKey) {
            this.dataFlowKey = dataFlowKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDataFlowRequest buildWithoutInvocationCallback() {
            return new GetDataFlowRequest(this.workspaceId, this.dataFlowKey, this.opcRequestId);
        }

        public String toString() {
            return "GetDataFlowRequest.Builder(workspaceId=" + this.workspaceId + ", dataFlowKey=" + this.dataFlowKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

