/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDataFlowValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String dataFlowValidationKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "dataFlowValidationKey", "opcRequestId"})
    GetDataFlowValidationRequest(String workspaceId, String dataFlowValidationKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.dataFlowValidationKey = dataFlowValidationKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataFlowValidationKey() {
        return this.dataFlowValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataFlowValidationRequest, Void> {
        private String workspaceId;
        private String dataFlowValidationKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataFlowValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataFlowValidationKey(o.getDataFlowValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataFlowValidationRequest build() {
            GetDataFlowValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataFlowValidationKey(String dataFlowValidationKey) {
            this.dataFlowValidationKey = dataFlowValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDataFlowValidationRequest buildWithoutInvocationCallback() {
            return new GetDataFlowValidationRequest(this.workspaceId, this.dataFlowValidationKey, this.opcRequestId);
        }

        public String toString() {
            return "GetDataFlowValidationRequest.Builder(workspaceId=" + this.workspaceId + ", dataFlowValidationKey=" + this.dataFlowValidationKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

