/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetExternalPublicationValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String externalPublicationValidationKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "taskKey", "externalPublicationValidationKey", "opcRequestId"})
    GetExternalPublicationValidationRequest(String workspaceId, String taskKey, String externalPublicationValidationKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.externalPublicationValidationKey = externalPublicationValidationKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getExternalPublicationValidationKey() {
        return this.externalPublicationValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalPublicationValidationRequest, Void> {
        private String workspaceId;
        private String taskKey;
        private String externalPublicationValidationKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalPublicationValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.externalPublicationValidationKey(o.getExternalPublicationValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalPublicationValidationRequest build() {
            GetExternalPublicationValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder externalPublicationValidationKey(String externalPublicationValidationKey) {
            this.externalPublicationValidationKey = externalPublicationValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetExternalPublicationValidationRequest buildWithoutInvocationCallback() {
            return new GetExternalPublicationValidationRequest(this.workspaceId, this.taskKey, this.externalPublicationValidationKey, this.opcRequestId);
        }

        public String toString() {
            return "GetExternalPublicationValidationRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", externalPublicationValidationKey=" + this.externalPublicationValidationKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

