/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetFolderRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String folderKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "folderKey", "opcRequestId"})
    GetFolderRequest(String workspaceId, String folderKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.folderKey = folderKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getFolderKey() {
        return this.folderKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFolderRequest, Void> {
        private String workspaceId;
        private String folderKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFolderRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.folderKey(o.getFolderKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFolderRequest build() {
            GetFolderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder folderKey(String folderKey) {
            this.folderKey = folderKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetFolderRequest buildWithoutInvocationCallback() {
            return new GetFolderRequest(this.workspaceId, this.folderKey, this.opcRequestId);
        }

        public String toString() {
            return "GetFolderRequest.Builder(workspaceId=" + this.workspaceId + ", folderKey=" + this.folderKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

