/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPipelineValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String pipelineValidationKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "pipelineValidationKey", "opcRequestId"})
    GetPipelineValidationRequest(String workspaceId, String pipelineValidationKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.pipelineValidationKey = pipelineValidationKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getPipelineValidationKey() {
        return this.pipelineValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPipelineValidationRequest, Void> {
        private String workspaceId;
        private String pipelineValidationKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPipelineValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.pipelineValidationKey(o.getPipelineValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPipelineValidationRequest build() {
            GetPipelineValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder pipelineValidationKey(String pipelineValidationKey) {
            this.pipelineValidationKey = pipelineValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPipelineValidationRequest buildWithoutInvocationCallback() {
            return new GetPipelineValidationRequest(this.workspaceId, this.pipelineValidationKey, this.opcRequestId);
        }

        public String toString() {
            return "GetPipelineValidationRequest.Builder(workspaceId=" + this.workspaceId + ", pipelineValidationKey=" + this.pipelineValidationKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

