/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPublishedObjectRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String publishedObjectKey;
    private String opcRequestId;
    private String expandReferences;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "publishedObjectKey", "opcRequestId", "expandReferences"})
    GetPublishedObjectRequest(String workspaceId, String applicationKey, String publishedObjectKey, String opcRequestId, String expandReferences) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.publishedObjectKey = publishedObjectKey;
        this.opcRequestId = opcRequestId;
        this.expandReferences = expandReferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getPublishedObjectKey() {
        return this.publishedObjectKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpandReferences() {
        return this.expandReferences;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublishedObjectRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private String publishedObjectKey;
        private String opcRequestId;
        private String expandReferences;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublishedObjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.publishedObjectKey(o.getPublishedObjectKey());
            this.opcRequestId(o.getOpcRequestId());
            this.expandReferences(o.getExpandReferences());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublishedObjectRequest build() {
            GetPublishedObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder publishedObjectKey(String publishedObjectKey) {
            this.publishedObjectKey = publishedObjectKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expandReferences(String expandReferences) {
            this.expandReferences = expandReferences;
            return this;
        }

        public GetPublishedObjectRequest buildWithoutInvocationCallback() {
            return new GetPublishedObjectRequest(this.workspaceId, this.applicationKey, this.publishedObjectKey, this.opcRequestId, this.expandReferences);
        }

        public String toString() {
            return "GetPublishedObjectRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", publishedObjectKey=" + this.publishedObjectKey + ", opcRequestId=" + this.opcRequestId + ", expandReferences=" + this.expandReferences + ")";
        }
    }
}

