/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDataAssetsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String page;
    private Integer limit;
    private List<String> fields;
    private String type;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String name;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "page", "limit", "fields", "type", "sortBy", "sortOrder", "name", "opcRequestId"})
    ListDataAssetsRequest(String workspaceId, String page, Integer limit, List<String> fields, String type, SortBy sortBy, SortOrder sortOrder, String name, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.page = page;
        this.limit = limit;
        this.fields = fields;
        this.type = type;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.name = name;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getType() {
        return this.type;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataAssetsRequest, Void> {
        private String workspaceId;
        private String page;
        private Integer limit;
        private List<String> fields;
        private String type;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String name;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataAssetsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.type(o.getType());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataAssetsRequest build() {
            ListDataAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListDataAssetsRequest buildWithoutInvocationCallback() {
            return new ListDataAssetsRequest(this.workspaceId, this.page, this.limit, this.fields, this.type, this.sortBy, this.sortOrder, this.name, this.opcRequestId);
        }

        public String toString() {
            return "ListDataAssetsRequest.Builder(workspaceId=" + this.workspaceId + ", page=" + this.page + ", limit=" + this.limit + ", fields=" + this.fields + ", type=" + this.type + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", name=" + this.name + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

