/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDataEntitiesRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private String name;
    private String page;
    private String type;
    private Integer limit;
    private List<String> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private List<String> nameList;
    private Boolean isPattern;

    @ConstructorProperties(value={"workspaceId", "connectionKey", "schemaResourceName", "name", "page", "type", "limit", "fields", "sortBy", "sortOrder", "opcRequestId", "nameList", "isPattern"})
    ListDataEntitiesRequest(String workspaceId, String connectionKey, String schemaResourceName, String name, String page, String type, Integer limit, List<String> fields, SortBy sortBy, SortOrder sortOrder, String opcRequestId, List<String> nameList, Boolean isPattern) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.schemaResourceName = schemaResourceName;
        this.name = name;
        this.page = page;
        this.type = type;
        this.limit = limit;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
        this.nameList = nameList;
        this.isPattern = isPattern;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public String getType() {
        return this.type;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public Boolean getIsPattern() {
        return this.isPattern;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataEntitiesRequest, Void> {
        private String workspaceId;
        private String connectionKey;
        private String schemaResourceName;
        private String name;
        private String page;
        private String type;
        private Integer limit;
        private List<String> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private List<String> nameList;
        private Boolean isPattern;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataEntitiesRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.name(o.getName());
            this.page(o.getPage());
            this.type(o.getType());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.nameList(o.getNameList());
            this.isPattern(o.getIsPattern());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataEntitiesRequest build() {
            ListDataEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nameList(List<String> nameList) {
            this.nameList = nameList;
            return this;
        }

        public Builder isPattern(Boolean isPattern) {
            this.isPattern = isPattern;
            return this;
        }

        public ListDataEntitiesRequest buildWithoutInvocationCallback() {
            return new ListDataEntitiesRequest(this.workspaceId, this.connectionKey, this.schemaResourceName, this.name, this.page, this.type, this.limit, this.fields, this.sortBy, this.sortOrder, this.opcRequestId, this.nameList, this.isPattern);
        }

        public String toString() {
            return "ListDataEntitiesRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", schemaResourceName=" + this.schemaResourceName + ", name=" + this.name + ", page=" + this.page + ", type=" + this.type + ", limit=" + this.limit + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ", nameList=" + this.nameList + ", isPattern=" + this.isPattern + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

