/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDataFlowsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String opcRequestId;
    private String folderId;
    private List<String> fields;
    private String name;
    private List<String> identifier;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"workspaceId", "opcRequestId", "folderId", "fields", "name", "identifier", "limit", "page", "sortOrder", "sortBy"})
    ListDataFlowsRequest(String workspaceId, String opcRequestId, String folderId, List<String> fields, String name, List<String> identifier, Integer limit, String page, SortOrder sortOrder, SortBy sortBy) {
        this.workspaceId = workspaceId;
        this.opcRequestId = opcRequestId;
        this.folderId = folderId;
        this.fields = fields;
        this.name = name;
        this.identifier = identifier;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataFlowsRequest, Void> {
        private String workspaceId;
        private String opcRequestId;
        private String folderId;
        private List<String> fields;
        private String name;
        private List<String> identifier;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataFlowsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.opcRequestId(o.getOpcRequestId());
            this.folderId(o.getFolderId());
            this.fields(o.getFields());
            this.name(o.getName());
            this.identifier(o.getIdentifier());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataFlowsRequest build() {
            ListDataFlowsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identifier(List<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListDataFlowsRequest buildWithoutInvocationCallback() {
            return new ListDataFlowsRequest(this.workspaceId, this.opcRequestId, this.folderId, this.fields, this.name, this.identifier, this.limit, this.page, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListDataFlowsRequest.Builder(workspaceId=" + this.workspaceId + ", opcRequestId=" + this.opcRequestId + ", folderId=" + this.folderId + ", fields=" + this.fields + ", name=" + this.name + ", identifier=" + this.identifier + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

