/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListExternalPublicationValidationsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String opcRequestId;
    private List<String> fields;
    private String name;
    private List<String> identifier;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"workspaceId", "taskKey", "opcRequestId", "fields", "name", "identifier", "page", "limit", "sortOrder", "sortBy"})
    ListExternalPublicationValidationsRequest(String workspaceId, String taskKey, String opcRequestId, List<String> fields, String name, List<String> identifier, String page, Integer limit, SortOrder sortOrder, SortBy sortBy) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.opcRequestId = opcRequestId;
        this.fields = fields;
        this.name = name;
        this.identifier = identifier;
        this.page = page;
        this.limit = limit;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder
    implements BmcRequest.Builder<ListExternalPublicationValidationsRequest, Void> {
        private String workspaceId;
        private String taskKey;
        private String opcRequestId;
        private List<String> fields;
        private String name;
        private List<String> identifier;
        private String page;
        private Integer limit;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListExternalPublicationValidationsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.opcRequestId(o.getOpcRequestId());
            this.fields(o.getFields());
            this.name(o.getName());
            this.identifier(o.getIdentifier());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListExternalPublicationValidationsRequest build() {
            ListExternalPublicationValidationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identifier(List<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListExternalPublicationValidationsRequest buildWithoutInvocationCallback() {
            return new ListExternalPublicationValidationsRequest(this.workspaceId, this.taskKey, this.opcRequestId, this.fields, this.name, this.identifier, this.page, this.limit, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListExternalPublicationValidationsRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", opcRequestId=" + this.opcRequestId + ", fields=" + this.fields + ", name=" + this.name + ", identifier=" + this.identifier + ", page=" + this.page + ", limit=" + this.limit + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

