/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSchemasRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionKey;
    private String schemaResourceName;
    private String page;
    private Integer limit;
    private List<String> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String name;
    private String opcRequestId;
    private List<String> nameList;

    @ConstructorProperties(value={"workspaceId", "connectionKey", "schemaResourceName", "page", "limit", "fields", "sortBy", "sortOrder", "name", "opcRequestId", "nameList"})
    ListSchemasRequest(String workspaceId, String connectionKey, String schemaResourceName, String page, Integer limit, List<String> fields, SortBy sortBy, SortOrder sortOrder, String name, String opcRequestId, List<String> nameList) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.schemaResourceName = schemaResourceName;
        this.page = page;
        this.limit = limit;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.name = name;
        this.opcRequestId = opcRequestId;
        this.nameList = nameList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getSchemaResourceName() {
        return this.schemaResourceName;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSchemasRequest, Void> {
        private String workspaceId;
        private String connectionKey;
        private String schemaResourceName;
        private String page;
        private Integer limit;
        private List<String> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String name;
        private String opcRequestId;
        private List<String> nameList;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSchemasRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.schemaResourceName(o.getSchemaResourceName());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.nameList(o.getNameList());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSchemasRequest build() {
            ListSchemasRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder schemaResourceName(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder nameList(List<String> nameList) {
            this.nameList = nameList;
            return this;
        }

        public ListSchemasRequest buildWithoutInvocationCallback() {
            return new ListSchemasRequest(this.workspaceId, this.connectionKey, this.schemaResourceName, this.page, this.limit, this.fields, this.sortBy, this.sortOrder, this.name, this.opcRequestId, this.nameList);
        }

        public String toString() {
            return "ListSchemasRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", schemaResourceName=" + this.schemaResourceName + ", page=" + this.page + ", limit=" + this.limit + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", name=" + this.name + ", opcRequestId=" + this.opcRequestId + ", nameList=" + this.nameList + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

