/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class StartWorkspaceRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"workspaceId", "ifMatch", "opcRequestId", "opcRetryToken"})
    StartWorkspaceRequest(String workspaceId, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<StartWorkspaceRequest, Void> {
        private String workspaceId;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StartWorkspaceRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StartWorkspaceRequest build() {
            StartWorkspaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public StartWorkspaceRequest buildWithoutInvocationCallback() {
            return new StartWorkspaceRequest(this.workspaceId, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "StartWorkspaceRequest.Builder(workspaceId=" + this.workspaceId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

