/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateReferenceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateReferenceRequest
extends BmcRequest<UpdateReferenceDetails> {
    private String workspaceId;
    private String applicationKey;
    private String referenceKey;
    private UpdateReferenceDetails updateReferenceDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    @InternalSdk
    public UpdateReferenceDetails getBody$() {
        return this.updateReferenceDetails;
    }

    @ConstructorProperties(value={"workspaceId", "applicationKey", "referenceKey", "updateReferenceDetails", "opcRequestId", "ifMatch", "opcRetryToken"})
    UpdateReferenceRequest(String workspaceId, String applicationKey, String referenceKey, UpdateReferenceDetails updateReferenceDetails, String opcRequestId, String ifMatch, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.referenceKey = referenceKey;
        this.updateReferenceDetails = updateReferenceDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public UpdateReferenceDetails getUpdateReferenceDetails() {
        return this.updateReferenceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateReferenceRequest, UpdateReferenceDetails> {
        private String workspaceId;
        private String applicationKey;
        private String referenceKey;
        private UpdateReferenceDetails updateReferenceDetails;
        private String opcRequestId;
        private String ifMatch;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateReferenceRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.referenceKey(o.getReferenceKey());
            this.updateReferenceDetails(o.getUpdateReferenceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateReferenceRequest build() {
            UpdateReferenceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateReferenceDetails body) {
            this.updateReferenceDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            return this;
        }

        public Builder updateReferenceDetails(UpdateReferenceDetails updateReferenceDetails) {
            this.updateReferenceDetails = updateReferenceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public UpdateReferenceRequest buildWithoutInvocationCallback() {
            return new UpdateReferenceRequest(this.workspaceId, this.applicationKey, this.referenceKey, this.updateReferenceDetails, this.opcRequestId, this.ifMatch, this.opcRetryToken);
        }

        public String toString() {
            return "UpdateReferenceRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", referenceKey=" + this.referenceKey + ", updateReferenceDetails=" + this.updateReferenceDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

