/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateTaskDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTaskRequest
extends BmcRequest<UpdateTaskDetails> {
    private String workspaceId;
    private String taskKey;
    private UpdateTaskDetails updateTaskDetails;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateTaskDetails getBody$() {
        return this.updateTaskDetails;
    }

    @ConstructorProperties(value={"workspaceId", "taskKey", "updateTaskDetails", "opcRequestId", "ifMatch"})
    UpdateTaskRequest(String workspaceId, String taskKey, UpdateTaskDetails updateTaskDetails, String opcRequestId, String ifMatch) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.updateTaskDetails = updateTaskDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public UpdateTaskDetails getUpdateTaskDetails() {
        return this.updateTaskDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTaskRequest, UpdateTaskDetails> {
        private String workspaceId;
        private String taskKey;
        private UpdateTaskDetails updateTaskDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTaskRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.updateTaskDetails(o.getUpdateTaskDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTaskRequest build() {
            UpdateTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTaskDetails body) {
            this.updateTaskDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder updateTaskDetails(UpdateTaskDetails updateTaskDetails) {
            this.updateTaskDetails = updateTaskDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateTaskRequest buildWithoutInvocationCallback() {
            return new UpdateTaskRequest(this.workspaceId, this.taskKey, this.updateTaskDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateTaskRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", updateTaskDetails=" + this.updateTaskDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

