/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateTaskRunDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTaskRunRequest
extends BmcRequest<UpdateTaskRunDetails> {
    private String workspaceId;
    private String applicationKey;
    private String taskRunKey;
    private UpdateTaskRunDetails updateTaskRunDetails;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateTaskRunDetails getBody$() {
        return this.updateTaskRunDetails;
    }

    @ConstructorProperties(value={"workspaceId", "applicationKey", "taskRunKey", "updateTaskRunDetails", "opcRequestId", "ifMatch"})
    UpdateTaskRunRequest(String workspaceId, String applicationKey, String taskRunKey, UpdateTaskRunDetails updateTaskRunDetails, String opcRequestId, String ifMatch) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.taskRunKey = taskRunKey;
        this.updateTaskRunDetails = updateTaskRunDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getTaskRunKey() {
        return this.taskRunKey;
    }

    public UpdateTaskRunDetails getUpdateTaskRunDetails() {
        return this.updateTaskRunDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTaskRunRequest, UpdateTaskRunDetails> {
        private String workspaceId;
        private String applicationKey;
        private String taskRunKey;
        private UpdateTaskRunDetails updateTaskRunDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTaskRunRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.taskRunKey(o.getTaskRunKey());
            this.updateTaskRunDetails(o.getUpdateTaskRunDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTaskRunRequest build() {
            UpdateTaskRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTaskRunDetails body) {
            this.updateTaskRunDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder taskRunKey(String taskRunKey) {
            this.taskRunKey = taskRunKey;
            return this;
        }

        public Builder updateTaskRunDetails(UpdateTaskRunDetails updateTaskRunDetails) {
            this.updateTaskRunDetails = updateTaskRunDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateTaskRunRequest buildWithoutInvocationCallback() {
            return new UpdateTaskRunRequest(this.workspaceId, this.applicationKey, this.taskRunKey, this.updateTaskRunDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateTaskRunRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", taskRunKey=" + this.taskRunKey + ", updateTaskRunDetails=" + this.updateTaskRunDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

