/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.datasafe.DataSafe;
import com.oracle.bmc.datasafe.model.LifecycleState;
import com.oracle.bmc.datasafe.requests.GetDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.GetOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.GetWorkRequestRequest;
import com.oracle.bmc.datasafe.responses.GetDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.GetOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DataSafeWaiters {
    private final ExecutorService executorService;
    private final DataSafe client;

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(GetDataSafeConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafeConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> forDataSafeConfiguration(BmcGenericWaiter waiter, GetDataSafeConfigurationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse>(){

            public GetDataSafeConfigurationResponse apply(GetDataSafeConfigurationRequest request) {
                return DataSafeWaiters.this.client.getDataSafeConfiguration(request);
            }
        }, (Predicate)new Predicate<GetDataSafeConfigurationResponse>(){

            public boolean apply(GetDataSafeConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getDataSafeConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSafePrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> forDataSafePrivateEndpoint(BmcGenericWaiter waiter, GetDataSafePrivateEndpointRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse>(){

            public GetDataSafePrivateEndpointResponse apply(GetDataSafePrivateEndpointRequest request) {
                return DataSafeWaiters.this.client.getDataSafePrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetDataSafePrivateEndpointResponse>(){

            public boolean apply(GetDataSafePrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getDataSafePrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(GetOnPremConnectorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOnPremConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOnPremConnectorRequest, GetOnPremConnectorResponse> forOnPremConnector(BmcGenericWaiter waiter, GetOnPremConnectorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetOnPremConnectorRequest, GetOnPremConnectorResponse>(){

            public GetOnPremConnectorResponse apply(GetOnPremConnectorRequest request) {
                return DataSafeWaiters.this.client.getOnPremConnector(request);
            }
        }, (Predicate)new Predicate<GetOnPremConnectorResponse>(){

            public boolean apply(GetOnPremConnectorResponse response) {
                return targetStatesSet.contains((Object)response.getOnPremConnector().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataSafeWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DataSafeWaiters(ExecutorService executorService, DataSafe client) {
        this.executorService = executorService;
        this.client = client;
    }
}

