/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datasafe.requests.ChangeOnPremConnectorCompartmentRequest;
import com.oracle.bmc.datasafe.responses.ChangeOnPremConnectorCompartmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeOnPremConnectorCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeOnPremConnectorCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeOnPremConnectorCompartmentRequest interceptRequest(ChangeOnPremConnectorCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeOnPremConnectorCompartmentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOnPremConnectorId(), (String)"onPremConnectorId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeOnPremConnectorCompartmentDetails(), (String)"changeOnPremConnectorCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("onPremConnectors").path(HttpUtils.encodePathSegment((String)request.getOnPremConnectorId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeOnPremConnectorCompartmentResponse> fromResponse() {
        Function<Response, ChangeOnPremConnectorCompartmentResponse> transformer = new Function<Response, ChangeOnPremConnectorCompartmentResponse>(){

            public ChangeOnPremConnectorCompartmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.datasafe.responses.ChangeOnPremConnectorCompartmentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ChangeOnPremConnectorCompartmentResponse.Builder builder = ChangeOnPremConnectorCompartmentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ChangeOnPremConnectorCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

