/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datasafe.requests.GenerateOnPremConnectorConfigurationRequest;
import com.oracle.bmc.datasafe.responses.GenerateOnPremConnectorConfigurationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateOnPremConnectorConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateOnPremConnectorConfigurationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GenerateOnPremConnectorConfigurationRequest interceptRequest(GenerateOnPremConnectorConfigurationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GenerateOnPremConnectorConfigurationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getGenerateOnPremConnectorConfigurationDetails(), (String)"generateOnPremConnectorConfigurationDetails is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOnPremConnectorId(), (String)"onPremConnectorId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("onPremConnectors").path(HttpUtils.encodePathSegment((String)request.getOnPremConnectorId())).path("actions").path("generateConfiguration");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/octet-stream"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, GenerateOnPremConnectorConfigurationResponse> fromResponse() {
        Function<Response, GenerateOnPremConnectorConfigurationResponse> transformer = new Function<Response, GenerateOnPremConnectorConfigurationResponse>(){

            public GenerateOnPremConnectorConfigurationResponse apply(Response rawResponse) {
                Optional lastModifiedHeader;
                Optional contentLengthHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datasafe.responses.GenerateOnPremConnectorConfigurationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GenerateOnPremConnectorConfigurationResponse.Builder builder = GenerateOnPremConnectorConfigurationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                GenerateOnPremConnectorConfigurationResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

