/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetModelArtifactContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetModelArtifactContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetModelArtifactContentRequest interceptRequest(GetModelArtifactContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetModelArtifactContentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("models").path(HttpUtils.encodePathSegment((String)request.getModelId())).path("artifact").path("content");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/octet-stream"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getRange() != null) {
            ib.header("range", (Object)request.getRange());
        }
        return ib;
    }

    public static Function<Response, GetModelArtifactContentResponse> fromResponse() {
        Function<Response, GetModelArtifactContentResponse> transformer = new Function<Response, GetModelArtifactContentResponse>(){

            public GetModelArtifactContentResponse apply(Response rawResponse) {
                Optional lastModifiedHeader;
                Optional contentMd5Header;
                Optional contentDispositionHeader;
                Optional contentLengthHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetModelArtifactContentResponse.Builder builder = GetModelArtifactContentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((contentDispositionHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-disposition")).isPresent()) {
                    builder.contentDisposition((String)HeaderUtils.toValue((String)"content-disposition", (String)((String)((List)contentDispositionHeader.get()).get(0)), String.class));
                }
                if ((contentMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"content-md5")).isPresent()) {
                    builder.contentMd5((String)HeaderUtils.toValue((String)"content-md5", (String)((String)((List)contentMd5Header.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                GetModelArtifactContentResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

