/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.DnsPaginators;
import com.oracle.bmc.dns.DnsWaiters;
import com.oracle.bmc.dns.internal.http.ChangeResolverCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeSteeringPolicyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeTsigKeyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeViewCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeZoneCompartmentConverter;
import com.oracle.bmc.dns.internal.http.CreateResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.CreateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.CreateViewConverter;
import com.oracle.bmc.dns.internal.http.CreateZoneConverter;
import com.oracle.bmc.dns.internal.http.DeleteDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.DeleteRRSetConverter;
import com.oracle.bmc.dns.internal.http.DeleteResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.DeleteTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.DeleteViewConverter;
import com.oracle.bmc.dns.internal.http.DeleteZoneConverter;
import com.oracle.bmc.dns.internal.http.GetDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.GetRRSetConverter;
import com.oracle.bmc.dns.internal.http.GetResolverConverter;
import com.oracle.bmc.dns.internal.http.GetResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.GetTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.GetViewConverter;
import com.oracle.bmc.dns.internal.http.GetZoneConverter;
import com.oracle.bmc.dns.internal.http.GetZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.ListResolverEndpointsConverter;
import com.oracle.bmc.dns.internal.http.ListResolversConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPoliciesConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPolicyAttachmentsConverter;
import com.oracle.bmc.dns.internal.http.ListTsigKeysConverter;
import com.oracle.bmc.dns.internal.http.ListViewsConverter;
import com.oracle.bmc.dns.internal.http.ListZonesConverter;
import com.oracle.bmc.dns.internal.http.PatchDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.PatchRRSetConverter;
import com.oracle.bmc.dns.internal.http.PatchZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateRRSetConverter;
import com.oracle.bmc.dns.internal.http.UpdateResolverConverter;
import com.oracle.bmc.dns.internal.http.UpdateResolverEndpointConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.UpdateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.UpdateViewConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneRecordsConverter;
import com.oracle.bmc.dns.requests.ChangeResolverCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeTsigKeyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeViewCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateTsigKeyRequest;
import com.oracle.bmc.dns.requests.CreateViewRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteDomainRecordsRequest;
import com.oracle.bmc.dns.requests.DeleteRRSetRequest;
import com.oracle.bmc.dns.requests.DeleteResolverEndpointRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteTsigKeyRequest;
import com.oracle.bmc.dns.requests.DeleteViewRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetResolverEndpointRequest;
import com.oracle.bmc.dns.requests.GetResolverRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.ListResolverEndpointsRequest;
import com.oracle.bmc.dns.requests.ListResolversRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListTsigKeysRequest;
import com.oracle.bmc.dns.requests.ListViewsRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.requests.PatchDomainRecordsRequest;
import com.oracle.bmc.dns.requests.PatchRRSetRequest;
import com.oracle.bmc.dns.requests.PatchZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateDomainRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.requests.UpdateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.UpdateResolverRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.requests.UpdateViewRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeResolverCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeTsigKeyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeViewCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateTsigKeyResponse;
import com.oracle.bmc.dns.responses.CreateViewResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteDomainRecordsResponse;
import com.oracle.bmc.dns.responses.DeleteRRSetResponse;
import com.oracle.bmc.dns.responses.DeleteResolverEndpointResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteTsigKeyResponse;
import com.oracle.bmc.dns.responses.DeleteViewResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetResolverEndpointResponse;
import com.oracle.bmc.dns.responses.GetResolverResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.ListResolverEndpointsResponse;
import com.oracle.bmc.dns.responses.ListResolversResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListTsigKeysResponse;
import com.oracle.bmc.dns.responses.ListViewsResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.dns.responses.PatchDomainRecordsResponse;
import com.oracle.bmc.dns.responses.PatchRRSetResponse;
import com.oracle.bmc.dns.responses.PatchZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateDomainRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.UpdateResolverResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.dns.responses.UpdateViewResponse;
import com.oracle.bmc.dns.responses.UpdateZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsClient
implements Dns {
    private static final Logger LOG = LoggerFactory.getLogger(DnsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DNS").serviceEndpointPrefix("dns").serviceEndpointTemplate("https://dns.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DnsWaiters waiters;
    private final DnsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Dns-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DnsWaiters(executorService, this);
        this.paginators = new DnsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeResolverCompartmentResponse changeResolverCompartment(ChangeResolverCompartmentRequest request) {
        LOG.trace("Called changeResolverCompartment");
        ChangeResolverCompartmentRequest interceptedRequest = ChangeResolverCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeResolverCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeResolverCompartmentResponse> transformer = ChangeResolverCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeResolverCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeResolverCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeResolverCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeResolverCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeSteeringPolicyCompartmentResponse changeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request) {
        LOG.trace("Called changeSteeringPolicyCompartment");
        ChangeSteeringPolicyCompartmentRequest interceptedRequest = ChangeSteeringPolicyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSteeringPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSteeringPolicyCompartmentResponse> transformer = ChangeSteeringPolicyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeSteeringPolicyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSteeringPolicyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSteeringPolicyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSteeringPolicyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeTsigKeyCompartmentResponse changeTsigKeyCompartment(ChangeTsigKeyCompartmentRequest request) {
        LOG.trace("Called changeTsigKeyCompartment");
        ChangeTsigKeyCompartmentRequest interceptedRequest = ChangeTsigKeyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTsigKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTsigKeyCompartmentResponse> transformer = ChangeTsigKeyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeTsigKeyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeTsigKeyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeTsigKeyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeTsigKeyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeViewCompartmentResponse changeViewCompartment(ChangeViewCompartmentRequest request) {
        LOG.trace("Called changeViewCompartment");
        ChangeViewCompartmentRequest interceptedRequest = ChangeViewCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeViewCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeViewCompartmentResponse> transformer = ChangeViewCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeViewCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeViewCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeViewCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeViewCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeZoneCompartmentResponse changeZoneCompartment(ChangeZoneCompartmentRequest request) {
        LOG.trace("Called changeZoneCompartment");
        ChangeZoneCompartmentRequest interceptedRequest = ChangeZoneCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeZoneCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeZoneCompartmentResponse> transformer = ChangeZoneCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeZoneCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeZoneCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeZoneCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeZoneCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateResolverEndpointResponse createResolverEndpoint(CreateResolverEndpointRequest request) {
        LOG.trace("Called createResolverEndpoint");
        CreateResolverEndpointRequest interceptedRequest = CreateResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateResolverEndpointResponse> transformer = CreateResolverEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateResolverEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateResolverEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateResolverEndpointDetails(), (BmcRequest)retriedRequest);
                return (CreateResolverEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSteeringPolicyResponse createSteeringPolicy(CreateSteeringPolicyRequest request) {
        LOG.trace("Called createSteeringPolicy");
        CreateSteeringPolicyRequest interceptedRequest = CreateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyResponse> transformer = CreateSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSteeringPolicyDetails(), (BmcRequest)retriedRequest);
                return (CreateSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSteeringPolicyAttachmentResponse createSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called createSteeringPolicyAttachment");
        CreateSteeringPolicyAttachmentRequest interceptedRequest = CreateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyAttachmentResponse> transformer = CreateSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSteeringPolicyAttachmentDetails(), (BmcRequest)retriedRequest);
                return (CreateSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTsigKeyResponse createTsigKey(CreateTsigKeyRequest request) {
        LOG.trace("Called createTsigKey");
        CreateTsigKeyRequest interceptedRequest = CreateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTsigKeyResponse> transformer = CreateTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTsigKeyDetails(), (BmcRequest)retriedRequest);
                return (CreateTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateViewResponse createView(CreateViewRequest request) {
        LOG.trace("Called createView");
        CreateViewRequest interceptedRequest = CreateViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateViewResponse> transformer = CreateViewConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateViewResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateViewResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateViewDetails(), (BmcRequest)retriedRequest);
                return (CreateViewResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateZoneResponse createZone(CreateZoneRequest request) {
        LOG.trace("Called createZone");
        CreateZoneRequest interceptedRequest = CreateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateZoneResponse> transformer = CreateZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateZoneDetails(), (BmcRequest)retriedRequest);
                return (CreateZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDomainRecordsResponse deleteDomainRecords(DeleteDomainRecordsRequest request) {
        LOG.trace("Called deleteDomainRecords");
        DeleteDomainRecordsRequest interceptedRequest = DeleteDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDomainRecordsResponse> transformer = DeleteDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRRSetResponse deleteRRSet(DeleteRRSetRequest request) {
        LOG.trace("Called deleteRRSet");
        DeleteRRSetRequest interceptedRequest = DeleteRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRRSetResponse> transformer = DeleteRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteResolverEndpointResponse deleteResolverEndpoint(DeleteResolverEndpointRequest request) {
        LOG.trace("Called deleteResolverEndpoint");
        DeleteResolverEndpointRequest interceptedRequest = DeleteResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteResolverEndpointResponse> transformer = DeleteResolverEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteResolverEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteResolverEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteResolverEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSteeringPolicyResponse deleteSteeringPolicy(DeleteSteeringPolicyRequest request) {
        LOG.trace("Called deleteSteeringPolicy");
        DeleteSteeringPolicyRequest interceptedRequest = DeleteSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyResponse> transformer = DeleteSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSteeringPolicyAttachmentResponse deleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called deleteSteeringPolicyAttachment");
        DeleteSteeringPolicyAttachmentRequest interceptedRequest = DeleteSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyAttachmentResponse> transformer = DeleteSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTsigKeyResponse deleteTsigKey(DeleteTsigKeyRequest request) {
        LOG.trace("Called deleteTsigKey");
        DeleteTsigKeyRequest interceptedRequest = DeleteTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTsigKeyResponse> transformer = DeleteTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteViewResponse deleteView(DeleteViewRequest request) {
        LOG.trace("Called deleteView");
        DeleteViewRequest interceptedRequest = DeleteViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteViewResponse> transformer = DeleteViewConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteViewResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteViewResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteViewResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteZoneResponse deleteZone(DeleteZoneRequest request) {
        LOG.trace("Called deleteZone");
        DeleteZoneRequest interceptedRequest = DeleteZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteZoneResponse> transformer = DeleteZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDomainRecordsResponse getDomainRecords(GetDomainRecordsRequest request) {
        LOG.trace("Called getDomainRecords");
        GetDomainRecordsRequest interceptedRequest = GetDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDomainRecordsResponse> transformer = GetDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRRSetResponse getRRSet(GetRRSetRequest request) {
        LOG.trace("Called getRRSet");
        GetRRSetRequest interceptedRequest = GetRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRRSetResponse> transformer = GetRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResolverResponse getResolver(GetResolverRequest request) {
        LOG.trace("Called getResolver");
        GetResolverRequest interceptedRequest = GetResolverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResolverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResolverResponse> transformer = GetResolverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResolverResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResolverResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResolverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResolverEndpointResponse getResolverEndpoint(GetResolverEndpointRequest request) {
        LOG.trace("Called getResolverEndpoint");
        GetResolverEndpointRequest interceptedRequest = GetResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResolverEndpointResponse> transformer = GetResolverEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResolverEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResolverEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResolverEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSteeringPolicyResponse getSteeringPolicy(GetSteeringPolicyRequest request) {
        LOG.trace("Called getSteeringPolicy");
        GetSteeringPolicyRequest interceptedRequest = GetSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyResponse> transformer = GetSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSteeringPolicyAttachmentResponse getSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called getSteeringPolicyAttachment");
        GetSteeringPolicyAttachmentRequest interceptedRequest = GetSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyAttachmentResponse> transformer = GetSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTsigKeyResponse getTsigKey(GetTsigKeyRequest request) {
        LOG.trace("Called getTsigKey");
        GetTsigKeyRequest interceptedRequest = GetTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTsigKeyResponse> transformer = GetTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetViewResponse getView(GetViewRequest request) {
        LOG.trace("Called getView");
        GetViewRequest interceptedRequest = GetViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetViewResponse> transformer = GetViewConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetViewResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetViewResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetViewResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetZoneResponse getZone(GetZoneRequest request) {
        LOG.trace("Called getZone");
        GetZoneRequest interceptedRequest = GetZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneResponse> transformer = GetZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetZoneRecordsResponse getZoneRecords(GetZoneRecordsRequest request) {
        LOG.trace("Called getZoneRecords");
        GetZoneRecordsRequest interceptedRequest = GetZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneRecordsResponse> transformer = GetZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResolverEndpointsResponse listResolverEndpoints(ListResolverEndpointsRequest request) {
        LOG.trace("Called listResolverEndpoints");
        ListResolverEndpointsRequest interceptedRequest = ListResolverEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResolverEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResolverEndpointsResponse> transformer = ListResolverEndpointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResolverEndpointsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResolverEndpointsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResolverEndpointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResolversResponse listResolvers(ListResolversRequest request) {
        LOG.trace("Called listResolvers");
        ListResolversRequest interceptedRequest = ListResolversConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResolversConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResolversResponse> transformer = ListResolversConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResolversResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResolversResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResolversResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSteeringPoliciesResponse listSteeringPolicies(ListSteeringPoliciesRequest request) {
        LOG.trace("Called listSteeringPolicies");
        ListSteeringPoliciesRequest interceptedRequest = ListSteeringPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPoliciesResponse> transformer = ListSteeringPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSteeringPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSteeringPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSteeringPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSteeringPolicyAttachmentsResponse listSteeringPolicyAttachments(ListSteeringPolicyAttachmentsRequest request) {
        LOG.trace("Called listSteeringPolicyAttachments");
        ListSteeringPolicyAttachmentsRequest interceptedRequest = ListSteeringPolicyAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPolicyAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = ListSteeringPolicyAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSteeringPolicyAttachmentsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSteeringPolicyAttachmentsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSteeringPolicyAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTsigKeysResponse listTsigKeys(ListTsigKeysRequest request) {
        LOG.trace("Called listTsigKeys");
        ListTsigKeysRequest interceptedRequest = ListTsigKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTsigKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTsigKeysResponse> transformer = ListTsigKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTsigKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTsigKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTsigKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListViewsResponse listViews(ListViewsRequest request) {
        LOG.trace("Called listViews");
        ListViewsRequest interceptedRequest = ListViewsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListViewsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListViewsResponse> transformer = ListViewsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListViewsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListViewsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListViewsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListZonesResponse listZones(ListZonesRequest request) {
        LOG.trace("Called listZones");
        ListZonesRequest interceptedRequest = ListZonesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListZonesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListZonesResponse> transformer = ListZonesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListZonesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListZonesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListZonesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchDomainRecordsResponse patchDomainRecords(PatchDomainRecordsRequest request) {
        LOG.trace("Called patchDomainRecords");
        PatchDomainRecordsRequest interceptedRequest = PatchDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchDomainRecordsResponse> transformer = PatchDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchDomainRecordsDetails(), (BmcRequest)retriedRequest);
                return (PatchDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchRRSetResponse patchRRSet(PatchRRSetRequest request) {
        LOG.trace("Called patchRRSet");
        PatchRRSetRequest interceptedRequest = PatchRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchRRSetResponse> transformer = PatchRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchRRSetDetails(), (BmcRequest)retriedRequest);
                return (PatchRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchZoneRecordsResponse patchZoneRecords(PatchZoneRecordsRequest request) {
        LOG.trace("Called patchZoneRecords");
        PatchZoneRecordsRequest interceptedRequest = PatchZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchZoneRecordsResponse> transformer = PatchZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchZoneRecordsDetails(), (BmcRequest)retriedRequest);
                return (PatchZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDomainRecordsResponse updateDomainRecords(UpdateDomainRecordsRequest request) {
        LOG.trace("Called updateDomainRecords");
        UpdateDomainRecordsRequest interceptedRequest = UpdateDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDomainRecordsResponse> transformer = UpdateDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDomainRecordsDetails(), (BmcRequest)retriedRequest);
                return (UpdateDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRRSetResponse updateRRSet(UpdateRRSetRequest request) {
        LOG.trace("Called updateRRSet");
        UpdateRRSetRequest interceptedRequest = UpdateRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRRSetResponse> transformer = UpdateRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRRSetDetails(), (BmcRequest)retriedRequest);
                return (UpdateRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest request) {
        LOG.trace("Called updateResolver");
        UpdateResolverRequest interceptedRequest = UpdateResolverConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResolverConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResolverResponse> transformer = UpdateResolverConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateResolverResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateResolverResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateResolverDetails(), (BmcRequest)retriedRequest);
                return (UpdateResolverResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateResolverEndpointResponse updateResolverEndpoint(UpdateResolverEndpointRequest request) {
        LOG.trace("Called updateResolverEndpoint");
        UpdateResolverEndpointRequest interceptedRequest = UpdateResolverEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResolverEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResolverEndpointResponse> transformer = UpdateResolverEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateResolverEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateResolverEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateResolverEndpointDetails(), (BmcRequest)retriedRequest);
                return (UpdateResolverEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSteeringPolicyResponse updateSteeringPolicy(UpdateSteeringPolicyRequest request) {
        LOG.trace("Called updateSteeringPolicy");
        UpdateSteeringPolicyRequest interceptedRequest = UpdateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyResponse> transformer = UpdateSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSteeringPolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdateSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSteeringPolicyAttachmentResponse updateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called updateSteeringPolicyAttachment");
        UpdateSteeringPolicyAttachmentRequest interceptedRequest = UpdateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyAttachmentResponse> transformer = UpdateSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSteeringPolicyAttachmentDetails(), (BmcRequest)retriedRequest);
                return (UpdateSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTsigKeyResponse updateTsigKey(UpdateTsigKeyRequest request) {
        LOG.trace("Called updateTsigKey");
        UpdateTsigKeyRequest interceptedRequest = UpdateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTsigKeyResponse> transformer = UpdateTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTsigKeyDetails(), (BmcRequest)retriedRequest);
                return (UpdateTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateViewResponse updateView(UpdateViewRequest request) {
        LOG.trace("Called updateView");
        UpdateViewRequest interceptedRequest = UpdateViewConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateViewConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateViewResponse> transformer = UpdateViewConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateViewResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateViewResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateViewDetails(), (BmcRequest)retriedRequest);
                return (UpdateViewResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateZoneResponse updateZone(UpdateZoneRequest request) {
        LOG.trace("Called updateZone");
        UpdateZoneRequest interceptedRequest = UpdateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneResponse> transformer = UpdateZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateZoneDetails(), (BmcRequest)retriedRequest);
                return (UpdateZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateZoneRecordsResponse updateZoneRecords(UpdateZoneRecordsRequest request) {
        LOG.trace("Called updateZoneRecords");
        UpdateZoneRecordsRequest interceptedRequest = UpdateZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneRecordsResponse> transformer = UpdateZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateZoneRecordsDetails(), (BmcRequest)retriedRequest);
                return (UpdateZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DnsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DnsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DnsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DnsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DnsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

