/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetViewRequest
extends BmcRequest<Void> {
    private String viewId;
    private String ifModifiedSince;
    private String ifNoneMatch;
    private String opcRequestId;
    private Scope scope;

    @ConstructorProperties(value={"viewId", "ifModifiedSince", "ifNoneMatch", "opcRequestId", "scope"})
    GetViewRequest(String viewId, String ifModifiedSince, String ifNoneMatch, String opcRequestId, Scope scope) {
        this.viewId = viewId;
        this.ifModifiedSince = ifModifiedSince;
        this.ifNoneMatch = ifNoneMatch;
        this.opcRequestId = opcRequestId;
        this.scope = scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    implements BmcRequest.Builder<GetViewRequest, Void> {
        private String viewId;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String opcRequestId;
        private Scope scope;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetViewRequest o) {
            this.viewId(o.getViewId());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetViewRequest build() {
            GetViewRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public GetViewRequest buildWithoutInvocationCallback() {
            return new GetViewRequest(this.viewId, this.ifModifiedSince, this.ifNoneMatch, this.opcRequestId, this.scope);
        }

        public String toString() {
            return "GetViewRequest.Builder(viewId=" + this.viewId + ", ifModifiedSince=" + this.ifModifiedSince + ", ifNoneMatch=" + this.ifNoneMatch + ", opcRequestId=" + this.opcRequestId + ", scope=" + (Object)((Object)this.scope) + ")";
        }
    }
}

