/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.ApplianceExportJobAsync;
import com.oracle.bmc.dts.internal.http.ChangeApplianceExportJobCompartmentConverter;
import com.oracle.bmc.dts.internal.http.CreateApplianceExportJobConverter;
import com.oracle.bmc.dts.internal.http.DeleteApplianceExportJobConverter;
import com.oracle.bmc.dts.internal.http.GetApplianceExportJobConverter;
import com.oracle.bmc.dts.internal.http.ListApplianceExportJobsConverter;
import com.oracle.bmc.dts.internal.http.UpdateApplianceExportJobConverter;
import com.oracle.bmc.dts.requests.ChangeApplianceExportJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.DeleteApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.GetApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.ListApplianceExportJobsRequest;
import com.oracle.bmc.dts.requests.UpdateApplianceExportJobRequest;
import com.oracle.bmc.dts.responses.ChangeApplianceExportJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.DeleteApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.GetApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.ListApplianceExportJobsResponse;
import com.oracle.bmc.dts.responses.UpdateApplianceExportJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplianceExportJobAsyncClient
implements ApplianceExportJobAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ApplianceExportJobAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLIANCEEXPORTJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeApplianceExportJobCompartmentResponse> changeApplianceExportJobCompartment(ChangeApplianceExportJobCompartmentRequest request, AsyncHandler<ChangeApplianceExportJobCompartmentRequest, ChangeApplianceExportJobCompartmentResponse> handler) {
        LOG.trace("Called async changeApplianceExportJobCompartment");
        ChangeApplianceExportJobCompartmentRequest interceptedRequest = ChangeApplianceExportJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApplianceExportJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApplianceExportJobCompartmentResponse> transformer = ChangeApplianceExportJobCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeApplianceExportJobCompartmentRequest, ChangeApplianceExportJobCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeApplianceExportJobCompartmentRequest, ChangeApplianceExportJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateApplianceExportJobResponse> createApplianceExportJob(CreateApplianceExportJobRequest request, AsyncHandler<CreateApplianceExportJobRequest, CreateApplianceExportJobResponse> handler) {
        LOG.trace("Called async createApplianceExportJob");
        CreateApplianceExportJobRequest interceptedRequest = CreateApplianceExportJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplianceExportJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplianceExportJobResponse> transformer = CreateApplianceExportJobConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateApplianceExportJobRequest, CreateApplianceExportJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateApplianceExportJobRequest, CreateApplianceExportJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApplianceExportJobResponse> deleteApplianceExportJob(DeleteApplianceExportJobRequest request, AsyncHandler<DeleteApplianceExportJobRequest, DeleteApplianceExportJobResponse> handler) {
        LOG.trace("Called async deleteApplianceExportJob");
        DeleteApplianceExportJobRequest interceptedRequest = DeleteApplianceExportJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplianceExportJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplianceExportJobResponse> transformer = DeleteApplianceExportJobConverter.fromResponse();
        AsyncHandler<DeleteApplianceExportJobRequest, DeleteApplianceExportJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApplianceExportJobRequest, DeleteApplianceExportJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApplianceExportJobResponse> getApplianceExportJob(GetApplianceExportJobRequest request, AsyncHandler<GetApplianceExportJobRequest, GetApplianceExportJobResponse> handler) {
        LOG.trace("Called async getApplianceExportJob");
        GetApplianceExportJobRequest interceptedRequest = GetApplianceExportJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplianceExportJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplianceExportJobResponse> transformer = GetApplianceExportJobConverter.fromResponse();
        AsyncHandler<GetApplianceExportJobRequest, GetApplianceExportJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApplianceExportJobRequest, GetApplianceExportJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApplianceExportJobsResponse> listApplianceExportJobs(ListApplianceExportJobsRequest request, AsyncHandler<ListApplianceExportJobsRequest, ListApplianceExportJobsResponse> handler) {
        LOG.trace("Called async listApplianceExportJobs");
        ListApplianceExportJobsRequest interceptedRequest = ListApplianceExportJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplianceExportJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplianceExportJobsResponse> transformer = ListApplianceExportJobsConverter.fromResponse();
        AsyncHandler<ListApplianceExportJobsRequest, ListApplianceExportJobsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApplianceExportJobsRequest, ListApplianceExportJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateApplianceExportJobResponse> updateApplianceExportJob(UpdateApplianceExportJobRequest request, AsyncHandler<UpdateApplianceExportJobRequest, UpdateApplianceExportJobResponse> handler) {
        LOG.trace("Called async updateApplianceExportJob");
        UpdateApplianceExportJobRequest interceptedRequest = UpdateApplianceExportJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplianceExportJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplianceExportJobResponse> transformer = UpdateApplianceExportJobConverter.fromResponse();
        AsyncHandler<UpdateApplianceExportJobRequest, UpdateApplianceExportJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateApplianceExportJobRequest, UpdateApplianceExportJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplianceExportJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApplianceExportJobAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApplianceExportJobAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

