/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dts.TransferPackage;
import com.oracle.bmc.dts.model.TransferPackage;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class TransferPackageWaiters {
    private final ExecutorService executorService;
    private final TransferPackage client;

    public Waiter<GetTransferPackageRequest, GetTransferPackageResponse> forTransferPackage(GetTransferPackageRequest request, TransferPackage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTransferPackage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTransferPackageRequest, GetTransferPackageResponse> forTransferPackage(GetTransferPackageRequest request, TransferPackage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTransferPackage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTransferPackageRequest, GetTransferPackageResponse> forTransferPackage(GetTransferPackageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TransferPackage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTransferPackage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTransferPackageRequest, GetTransferPackageResponse> forTransferPackage(BmcGenericWaiter waiter, GetTransferPackageRequest request, TransferPackage.LifecycleState ... targetStates) {
        final HashSet<TransferPackage.LifecycleState> targetStatesSet = new HashSet<TransferPackage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTransferPackageRequest, GetTransferPackageResponse>(){

            public GetTransferPackageResponse apply(GetTransferPackageRequest request) {
                return TransferPackageWaiters.this.client.getTransferPackage(request);
            }
        }, (Predicate)new Predicate<GetTransferPackageResponse>(){

            public boolean apply(GetTransferPackageResponse response) {
                return targetStatesSet.contains((Object)response.getTransferPackage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TransferPackage.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public TransferPackageWaiters(ExecutorService executorService, TransferPackage client) {
        this.executorService = executorService;
        this.client = client;
    }
}

