/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.healthchecks.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.healthchecks.model.PingMonitor;
import com.oracle.bmc.healthchecks.requests.UpdatePingMonitorRequest;
import com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePingMonitorConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatePingMonitorConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdatePingMonitorRequest interceptRequest(UpdatePingMonitorRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdatePingMonitorRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdatePingMonitorDetails(), (String)"updatePingMonitorDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180501").path("pingMonitors").path(HttpUtils.encodePathSegment((String)request.getMonitorId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdatePingMonitorResponse> fromResponse() {
        Function<Response, UpdatePingMonitorResponse> transformer = new Function<Response, UpdatePingMonitorResponse>(){

            public UpdatePingMonitorResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.healthchecks.responses.UpdatePingMonitorResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(PingMonitor.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdatePingMonitorResponse.Builder builder = UpdatePingMonitorResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.pingMonitor((PingMonitor)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                UpdatePingMonitorResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

