/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.identity.IdentityAsync;
import com.oracle.bmc.identity.internal.http.ActivateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.AddUserToGroupConverter;
import com.oracle.bmc.identity.internal.http.AssembleEffectiveTagSetConverter;
import com.oracle.bmc.identity.internal.http.BulkDeleteResourcesConverter;
import com.oracle.bmc.identity.internal.http.BulkDeleteTagsConverter;
import com.oracle.bmc.identity.internal.http.BulkEditTagsConverter;
import com.oracle.bmc.identity.internal.http.BulkMoveResourcesConverter;
import com.oracle.bmc.identity.internal.http.CascadeDeleteTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.ChangeTagNamespaceCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.CreateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.CreateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.CreateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.CreateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.CreateNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.CreateOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.CreateOrResetUIPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreatePolicyConverter;
import com.oracle.bmc.identity.internal.http.CreateRegionSubscriptionConverter;
import com.oracle.bmc.identity.internal.http.CreateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.CreateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreateTagConverter;
import com.oracle.bmc.identity.internal.http.CreateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.CreateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.CreateUserConverter;
import com.oracle.bmc.identity.internal.http.DeleteApiKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.DeleteCompartmentConverter;
import com.oracle.bmc.identity.internal.http.DeleteCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.DeleteMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.DeleteNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.DeleteOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.DeletePolicyConverter;
import com.oracle.bmc.identity.internal.http.DeleteSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.DeleteSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.DeleteUserConverter;
import com.oracle.bmc.identity.internal.http.GenerateTotpSeedConverter;
import com.oracle.bmc.identity.internal.http.GetAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetCompartmentConverter;
import com.oracle.bmc.identity.internal.http.GetDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.GetGroupConverter;
import com.oracle.bmc.identity.internal.http.GetIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.GetIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.GetMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.GetNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.GetPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetTagConverter;
import com.oracle.bmc.identity.internal.http.GetTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.GetTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.GetTaggingWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.GetTenancyConverter;
import com.oracle.bmc.identity.internal.http.GetUserConverter;
import com.oracle.bmc.identity.internal.http.GetUserGroupMembershipConverter;
import com.oracle.bmc.identity.internal.http.GetUserUIPasswordInformationConverter;
import com.oracle.bmc.identity.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.ListApiKeysConverter;
import com.oracle.bmc.identity.internal.http.ListAuthTokensConverter;
import com.oracle.bmc.identity.internal.http.ListAvailabilityDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListBulkActionResourceTypesConverter;
import com.oracle.bmc.identity.internal.http.ListBulkEditTagsResourceTypesConverter;
import com.oracle.bmc.identity.internal.http.ListCompartmentsConverter;
import com.oracle.bmc.identity.internal.http.ListCostTrackingTagsConverter;
import com.oracle.bmc.identity.internal.http.ListCustomerSecretKeysConverter;
import com.oracle.bmc.identity.internal.http.ListDynamicGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListFaultDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProviderGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProvidersConverter;
import com.oracle.bmc.identity.internal.http.ListIdpGroupMappingsConverter;
import com.oracle.bmc.identity.internal.http.ListMfaTotpDevicesConverter;
import com.oracle.bmc.identity.internal.http.ListNetworkSourcesConverter;
import com.oracle.bmc.identity.internal.http.ListOAuthClientCredentialsConverter;
import com.oracle.bmc.identity.internal.http.ListPoliciesConverter;
import com.oracle.bmc.identity.internal.http.ListRegionSubscriptionsConverter;
import com.oracle.bmc.identity.internal.http.ListRegionsConverter;
import com.oracle.bmc.identity.internal.http.ListSmtpCredentialsConverter;
import com.oracle.bmc.identity.internal.http.ListSwiftPasswordsConverter;
import com.oracle.bmc.identity.internal.http.ListTagDefaultsConverter;
import com.oracle.bmc.identity.internal.http.ListTagNamespacesConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestErrorsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestLogsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.ListTagsConverter;
import com.oracle.bmc.identity.internal.http.ListUserGroupMembershipsConverter;
import com.oracle.bmc.identity.internal.http.ListUsersConverter;
import com.oracle.bmc.identity.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.MoveCompartmentConverter;
import com.oracle.bmc.identity.internal.http.RecoverCompartmentConverter;
import com.oracle.bmc.identity.internal.http.RemoveUserFromGroupConverter;
import com.oracle.bmc.identity.internal.http.ResetIdpScimClientConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.UpdateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.UpdateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.UpdateNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.UpdateOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.UpdatePolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.UpdateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserCapabilitiesConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserStateConverter;
import com.oracle.bmc.identity.internal.http.UploadApiKeyConverter;
import com.oracle.bmc.identity.requests.ActivateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.AddUserToGroupRequest;
import com.oracle.bmc.identity.requests.AssembleEffectiveTagSetRequest;
import com.oracle.bmc.identity.requests.BulkDeleteResourcesRequest;
import com.oracle.bmc.identity.requests.BulkDeleteTagsRequest;
import com.oracle.bmc.identity.requests.BulkEditTagsRequest;
import com.oracle.bmc.identity.requests.BulkMoveResourcesRequest;
import com.oracle.bmc.identity.requests.CascadeDeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.ChangeTagNamespaceCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateAuthTokenRequest;
import com.oracle.bmc.identity.requests.CreateCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.CreateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.CreateGroupRequest;
import com.oracle.bmc.identity.requests.CreateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.CreateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.CreateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.CreateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.CreateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.CreateOrResetUIPasswordRequest;
import com.oracle.bmc.identity.requests.CreatePolicyRequest;
import com.oracle.bmc.identity.requests.CreateRegionSubscriptionRequest;
import com.oracle.bmc.identity.requests.CreateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.CreateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.CreateTagDefaultRequest;
import com.oracle.bmc.identity.requests.CreateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.CreateTagRequest;
import com.oracle.bmc.identity.requests.CreateUserRequest;
import com.oracle.bmc.identity.requests.DeleteApiKeyRequest;
import com.oracle.bmc.identity.requests.DeleteAuthTokenRequest;
import com.oracle.bmc.identity.requests.DeleteCompartmentRequest;
import com.oracle.bmc.identity.requests.DeleteCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.DeleteDynamicGroupRequest;
import com.oracle.bmc.identity.requests.DeleteGroupRequest;
import com.oracle.bmc.identity.requests.DeleteIdentityProviderRequest;
import com.oracle.bmc.identity.requests.DeleteIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.DeleteMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.DeleteNetworkSourceRequest;
import com.oracle.bmc.identity.requests.DeleteOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.DeletePolicyRequest;
import com.oracle.bmc.identity.requests.DeleteSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.DeleteSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.DeleteTagDefaultRequest;
import com.oracle.bmc.identity.requests.DeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.DeleteTagRequest;
import com.oracle.bmc.identity.requests.DeleteUserRequest;
import com.oracle.bmc.identity.requests.GenerateTotpSeedRequest;
import com.oracle.bmc.identity.requests.GetAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.GetCompartmentRequest;
import com.oracle.bmc.identity.requests.GetDynamicGroupRequest;
import com.oracle.bmc.identity.requests.GetGroupRequest;
import com.oracle.bmc.identity.requests.GetIdentityProviderRequest;
import com.oracle.bmc.identity.requests.GetIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.GetMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.GetNetworkSourceRequest;
import com.oracle.bmc.identity.requests.GetPolicyRequest;
import com.oracle.bmc.identity.requests.GetTagDefaultRequest;
import com.oracle.bmc.identity.requests.GetTagNamespaceRequest;
import com.oracle.bmc.identity.requests.GetTagRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.GetUserGroupMembershipRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.GetUserUIPasswordInformationRequest;
import com.oracle.bmc.identity.requests.GetWorkRequestRequest;
import com.oracle.bmc.identity.requests.ListApiKeysRequest;
import com.oracle.bmc.identity.requests.ListAuthTokensRequest;
import com.oracle.bmc.identity.requests.ListAvailabilityDomainsRequest;
import com.oracle.bmc.identity.requests.ListBulkActionResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListBulkEditTagsResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListCostTrackingTagsRequest;
import com.oracle.bmc.identity.requests.ListCustomerSecretKeysRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListFaultDomainsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListNetworkSourcesRequest;
import com.oracle.bmc.identity.requests.ListOAuthClientCredentialsRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.requests.ListRegionsRequest;
import com.oracle.bmc.identity.requests.ListSmtpCredentialsRequest;
import com.oracle.bmc.identity.requests.ListSwiftPasswordsRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.requests.MoveCompartmentRequest;
import com.oracle.bmc.identity.requests.RecoverCompartmentRequest;
import com.oracle.bmc.identity.requests.RemoveUserFromGroupRequest;
import com.oracle.bmc.identity.requests.ResetIdpScimClientRequest;
import com.oracle.bmc.identity.requests.UpdateAuthTokenRequest;
import com.oracle.bmc.identity.requests.UpdateAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.UpdateCompartmentRequest;
import com.oracle.bmc.identity.requests.UpdateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.UpdateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.UpdateGroupRequest;
import com.oracle.bmc.identity.requests.UpdateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.UpdateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.UpdateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.UpdateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.UpdatePolicyRequest;
import com.oracle.bmc.identity.requests.UpdateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.UpdateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.UpdateTagDefaultRequest;
import com.oracle.bmc.identity.requests.UpdateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.UpdateTagRequest;
import com.oracle.bmc.identity.requests.UpdateUserCapabilitiesRequest;
import com.oracle.bmc.identity.requests.UpdateUserRequest;
import com.oracle.bmc.identity.requests.UpdateUserStateRequest;
import com.oracle.bmc.identity.requests.UploadApiKeyRequest;
import com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.AddUserToGroupResponse;
import com.oracle.bmc.identity.responses.AssembleEffectiveTagSetResponse;
import com.oracle.bmc.identity.responses.BulkDeleteResourcesResponse;
import com.oracle.bmc.identity.responses.BulkDeleteTagsResponse;
import com.oracle.bmc.identity.responses.BulkEditTagsResponse;
import com.oracle.bmc.identity.responses.BulkMoveResourcesResponse;
import com.oracle.bmc.identity.responses.CascadeDeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.ChangeTagNamespaceCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateAuthTokenResponse;
import com.oracle.bmc.identity.responses.CreateCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.CreateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.CreateGroupResponse;
import com.oracle.bmc.identity.responses.CreateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.CreateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.CreateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.CreateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.CreateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.CreateOrResetUIPasswordResponse;
import com.oracle.bmc.identity.responses.CreatePolicyResponse;
import com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse;
import com.oracle.bmc.identity.responses.CreateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.CreateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.CreateTagDefaultResponse;
import com.oracle.bmc.identity.responses.CreateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.CreateTagResponse;
import com.oracle.bmc.identity.responses.CreateUserResponse;
import com.oracle.bmc.identity.responses.DeleteApiKeyResponse;
import com.oracle.bmc.identity.responses.DeleteAuthTokenResponse;
import com.oracle.bmc.identity.responses.DeleteCompartmentResponse;
import com.oracle.bmc.identity.responses.DeleteCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.DeleteDynamicGroupResponse;
import com.oracle.bmc.identity.responses.DeleteGroupResponse;
import com.oracle.bmc.identity.responses.DeleteIdentityProviderResponse;
import com.oracle.bmc.identity.responses.DeleteIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.DeleteMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.DeleteNetworkSourceResponse;
import com.oracle.bmc.identity.responses.DeleteOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.DeletePolicyResponse;
import com.oracle.bmc.identity.responses.DeleteSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.DeleteSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.DeleteTagDefaultResponse;
import com.oracle.bmc.identity.responses.DeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.DeleteTagResponse;
import com.oracle.bmc.identity.responses.DeleteUserResponse;
import com.oracle.bmc.identity.responses.GenerateTotpSeedResponse;
import com.oracle.bmc.identity.responses.GetAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.GetCompartmentResponse;
import com.oracle.bmc.identity.responses.GetDynamicGroupResponse;
import com.oracle.bmc.identity.responses.GetGroupResponse;
import com.oracle.bmc.identity.responses.GetIdentityProviderResponse;
import com.oracle.bmc.identity.responses.GetIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.GetMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.GetNetworkSourceResponse;
import com.oracle.bmc.identity.responses.GetPolicyResponse;
import com.oracle.bmc.identity.responses.GetTagDefaultResponse;
import com.oracle.bmc.identity.responses.GetTagNamespaceResponse;
import com.oracle.bmc.identity.responses.GetTagResponse;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.GetUserGroupMembershipResponse;
import com.oracle.bmc.identity.responses.GetUserResponse;
import com.oracle.bmc.identity.responses.GetUserUIPasswordInformationResponse;
import com.oracle.bmc.identity.responses.GetWorkRequestResponse;
import com.oracle.bmc.identity.responses.ListApiKeysResponse;
import com.oracle.bmc.identity.responses.ListAuthTokensResponse;
import com.oracle.bmc.identity.responses.ListAvailabilityDomainsResponse;
import com.oracle.bmc.identity.responses.ListBulkActionResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListBulkEditTagsResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListCostTrackingTagsResponse;
import com.oracle.bmc.identity.responses.ListCustomerSecretKeysResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListFaultDomainsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListNetworkSourcesResponse;
import com.oracle.bmc.identity.responses.ListOAuthClientCredentialsResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import com.oracle.bmc.identity.responses.ListRegionsResponse;
import com.oracle.bmc.identity.responses.ListSmtpCredentialsResponse;
import com.oracle.bmc.identity.responses.ListSwiftPasswordsResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.identity.responses.MoveCompartmentResponse;
import com.oracle.bmc.identity.responses.RecoverCompartmentResponse;
import com.oracle.bmc.identity.responses.RemoveUserFromGroupResponse;
import com.oracle.bmc.identity.responses.ResetIdpScimClientResponse;
import com.oracle.bmc.identity.responses.UpdateAuthTokenResponse;
import com.oracle.bmc.identity.responses.UpdateAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.UpdateCompartmentResponse;
import com.oracle.bmc.identity.responses.UpdateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.UpdateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.UpdateGroupResponse;
import com.oracle.bmc.identity.responses.UpdateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.UpdateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.UpdateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.UpdatePolicyResponse;
import com.oracle.bmc.identity.responses.UpdateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.UpdateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.UpdateTagDefaultResponse;
import com.oracle.bmc.identity.responses.UpdateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.UpdateTagResponse;
import com.oracle.bmc.identity.responses.UpdateUserCapabilitiesResponse;
import com.oracle.bmc.identity.responses.UpdateUserResponse;
import com.oracle.bmc.identity.responses.UpdateUserStateResponse;
import com.oracle.bmc.identity.responses.UploadApiKeyResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityAsyncClient
implements IdentityAsync {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("IDENTITY").serviceEndpointPrefix("identity").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateMfaTotpDeviceResponse> activateMfaTotpDevice(ActivateMfaTotpDeviceRequest request, AsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async activateMfaTotpDevice");
        ActivateMfaTotpDeviceRequest interceptedRequest = ActivateMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ActivateMfaTotpDeviceResponse> transformer = ActivateMfaTotpDeviceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AddUserToGroupResponse> addUserToGroup(AddUserToGroupRequest request, AsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse> handler) {
        LOG.trace("Called async addUserToGroup");
        AddUserToGroupRequest interceptedRequest = AddUserToGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddUserToGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AddUserToGroupResponse> transformer = AddUserToGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddUserToGroupRequest, AddUserToGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AssembleEffectiveTagSetResponse> assembleEffectiveTagSet(AssembleEffectiveTagSetRequest request, AsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> handler) {
        LOG.trace("Called async assembleEffectiveTagSet");
        AssembleEffectiveTagSetRequest interceptedRequest = AssembleEffectiveTagSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AssembleEffectiveTagSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AssembleEffectiveTagSetResponse> transformer = AssembleEffectiveTagSetConverter.fromResponse();
        AsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BulkDeleteResourcesResponse> bulkDeleteResources(BulkDeleteResourcesRequest request, AsyncHandler<BulkDeleteResourcesRequest, BulkDeleteResourcesResponse> handler) {
        LOG.trace("Called async bulkDeleteResources");
        BulkDeleteResourcesRequest interceptedRequest = BulkDeleteResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkDeleteResourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, BulkDeleteResourcesResponse> transformer = BulkDeleteResourcesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BulkDeleteResourcesRequest, BulkDeleteResourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BulkDeleteResourcesRequest, BulkDeleteResourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BulkDeleteTagsResponse> bulkDeleteTags(BulkDeleteTagsRequest request, AsyncHandler<BulkDeleteTagsRequest, BulkDeleteTagsResponse> handler) {
        LOG.trace("Called async bulkDeleteTags");
        BulkDeleteTagsRequest interceptedRequest = BulkDeleteTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkDeleteTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, BulkDeleteTagsResponse> transformer = BulkDeleteTagsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BulkDeleteTagsRequest, BulkDeleteTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BulkDeleteTagsRequest, BulkDeleteTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BulkEditTagsResponse> bulkEditTags(BulkEditTagsRequest request, AsyncHandler<BulkEditTagsRequest, BulkEditTagsResponse> handler) {
        LOG.trace("Called async bulkEditTags");
        BulkEditTagsRequest interceptedRequest = BulkEditTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkEditTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, BulkEditTagsResponse> transformer = BulkEditTagsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BulkEditTagsRequest, BulkEditTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BulkEditTagsRequest, BulkEditTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BulkMoveResourcesResponse> bulkMoveResources(BulkMoveResourcesRequest request, AsyncHandler<BulkMoveResourcesRequest, BulkMoveResourcesResponse> handler) {
        LOG.trace("Called async bulkMoveResources");
        BulkMoveResourcesRequest interceptedRequest = BulkMoveResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkMoveResourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, BulkMoveResourcesResponse> transformer = BulkMoveResourcesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BulkMoveResourcesRequest, BulkMoveResourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BulkMoveResourcesRequest, BulkMoveResourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CascadeDeleteTagNamespaceResponse> cascadeDeleteTagNamespace(CascadeDeleteTagNamespaceRequest request, AsyncHandler<CascadeDeleteTagNamespaceRequest, CascadeDeleteTagNamespaceResponse> handler) {
        LOG.trace("Called async cascadeDeleteTagNamespace");
        CascadeDeleteTagNamespaceRequest interceptedRequest = CascadeDeleteTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CascadeDeleteTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CascadeDeleteTagNamespaceResponse> transformer = CascadeDeleteTagNamespaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CascadeDeleteTagNamespaceRequest, CascadeDeleteTagNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CascadeDeleteTagNamespaceRequest, CascadeDeleteTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeTagNamespaceCompartmentResponse> changeTagNamespaceCompartment(ChangeTagNamespaceCompartmentRequest request, AsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> handler) {
        LOG.trace("Called async changeTagNamespaceCompartment");
        ChangeTagNamespaceCompartmentRequest interceptedRequest = ChangeTagNamespaceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTagNamespaceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeTagNamespaceCompartmentResponse> transformer = ChangeTagNamespaceCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAuthTokenResponse> createAuthToken(CreateAuthTokenRequest request, AsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse> handler) {
        LOG.trace("Called async createAuthToken");
        CreateAuthTokenRequest interceptedRequest = CreateAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateAuthTokenResponse> transformer = CreateAuthTokenConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAuthTokenRequest, CreateAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCompartmentResponse> createCompartment(CreateCompartmentRequest request, AsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse> handler) {
        LOG.trace("Called async createCompartment");
        CreateCompartmentRequest interceptedRequest = CreateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCompartmentResponse> transformer = CreateCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCompartmentRequest, CreateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCustomerSecretKeyResponse> createCustomerSecretKey(CreateCustomerSecretKeyRequest request, AsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async createCustomerSecretKey");
        CreateCustomerSecretKeyRequest interceptedRequest = CreateCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCustomerSecretKeyResponse> transformer = CreateCustomerSecretKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDynamicGroupResponse> createDynamicGroup(CreateDynamicGroupRequest request, AsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse> handler) {
        LOG.trace("Called async createDynamicGroup");
        CreateDynamicGroupRequest interceptedRequest = CreateDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDynamicGroupResponse> transformer = CreateDynamicGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDynamicGroupRequest, CreateDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateGroupResponse> createGroup(CreateGroupRequest request, AsyncHandler<CreateGroupRequest, CreateGroupResponse> handler) {
        LOG.trace("Called async createGroup");
        CreateGroupRequest interceptedRequest = CreateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateGroupResponse> transformer = CreateGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateGroupRequest, CreateGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateGroupRequest, CreateGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateIdentityProviderResponse> createIdentityProvider(CreateIdentityProviderRequest request, AsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse> handler) {
        LOG.trace("Called async createIdentityProvider");
        CreateIdentityProviderRequest interceptedRequest = CreateIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateIdentityProviderResponse> transformer = CreateIdentityProviderConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateIdentityProviderRequest, CreateIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateIdpGroupMappingResponse> createIdpGroupMapping(CreateIdpGroupMappingRequest request, AsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> handler) {
        LOG.trace("Called async createIdpGroupMapping");
        CreateIdpGroupMappingRequest interceptedRequest = CreateIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateIdpGroupMappingResponse> transformer = CreateIdpGroupMappingConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateMfaTotpDeviceResponse> createMfaTotpDevice(CreateMfaTotpDeviceRequest request, AsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async createMfaTotpDevice");
        CreateMfaTotpDeviceRequest interceptedRequest = CreateMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateMfaTotpDeviceResponse> transformer = CreateMfaTotpDeviceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateNetworkSourceResponse> createNetworkSource(CreateNetworkSourceRequest request, AsyncHandler<CreateNetworkSourceRequest, CreateNetworkSourceResponse> handler) {
        LOG.trace("Called async createNetworkSource");
        CreateNetworkSourceRequest interceptedRequest = CreateNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateNetworkSourceResponse> transformer = CreateNetworkSourceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateNetworkSourceRequest, CreateNetworkSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateNetworkSourceRequest, CreateNetworkSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOAuthClientCredentialResponse> createOAuthClientCredential(CreateOAuthClientCredentialRequest request, AsyncHandler<CreateOAuthClientCredentialRequest, CreateOAuthClientCredentialResponse> handler) {
        LOG.trace("Called async createOAuthClientCredential");
        CreateOAuthClientCredentialRequest interceptedRequest = CreateOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateOAuthClientCredentialResponse> transformer = CreateOAuthClientCredentialConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateOAuthClientCredentialRequest, CreateOAuthClientCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOAuthClientCredentialRequest, CreateOAuthClientCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOrResetUIPasswordResponse> createOrResetUIPassword(CreateOrResetUIPasswordRequest request, AsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> handler) {
        LOG.trace("Called async createOrResetUIPassword");
        CreateOrResetUIPasswordRequest interceptedRequest = CreateOrResetUIPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOrResetUIPasswordConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateOrResetUIPasswordResponse> transformer = CreateOrResetUIPasswordConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePolicyResponse> createPolicy(CreatePolicyRequest request, AsyncHandler<CreatePolicyRequest, CreatePolicyResponse> handler) {
        LOG.trace("Called async createPolicy");
        CreatePolicyRequest interceptedRequest = CreatePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePolicyResponse> transformer = CreatePolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePolicyRequest, CreatePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePolicyRequest, CreatePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRegionSubscriptionResponse> createRegionSubscription(CreateRegionSubscriptionRequest request, AsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> handler) {
        LOG.trace("Called async createRegionSubscription");
        CreateRegionSubscriptionRequest interceptedRequest = CreateRegionSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRegionSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateRegionSubscriptionResponse> transformer = CreateRegionSubscriptionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSmtpCredentialResponse> createSmtpCredential(CreateSmtpCredentialRequest request, AsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> handler) {
        LOG.trace("Called async createSmtpCredential");
        CreateSmtpCredentialRequest interceptedRequest = CreateSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateSmtpCredentialResponse> transformer = CreateSmtpCredentialConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSwiftPasswordResponse> createSwiftPassword(CreateSwiftPasswordRequest request, AsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> handler) {
        LOG.trace("Called async createSwiftPassword");
        CreateSwiftPasswordRequest interceptedRequest = CreateSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateSwiftPasswordResponse> transformer = CreateSwiftPasswordConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTagResponse> createTag(CreateTagRequest request, AsyncHandler<CreateTagRequest, CreateTagResponse> handler) {
        LOG.trace("Called async createTag");
        CreateTagRequest interceptedRequest = CreateTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTagResponse> transformer = CreateTagConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTagRequest, CreateTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTagRequest, CreateTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTagDefaultResponse> createTagDefault(CreateTagDefaultRequest request, AsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse> handler) {
        LOG.trace("Called async createTagDefault");
        CreateTagDefaultRequest interceptedRequest = CreateTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTagDefaultResponse> transformer = CreateTagDefaultConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTagDefaultRequest, CreateTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTagNamespaceResponse> createTagNamespace(CreateTagNamespaceRequest request, AsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse> handler) {
        LOG.trace("Called async createTagNamespace");
        CreateTagNamespaceRequest interceptedRequest = CreateTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTagNamespaceResponse> transformer = CreateTagNamespaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTagNamespaceRequest, CreateTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateUserResponse> createUser(CreateUserRequest request, AsyncHandler<CreateUserRequest, CreateUserResponse> handler) {
        LOG.trace("Called async createUser");
        CreateUserRequest interceptedRequest = CreateUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateUserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateUserResponse> transformer = CreateUserConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateUserRequest, CreateUserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateUserRequest, CreateUserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest request, AsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse> handler) {
        LOG.trace("Called async deleteApiKey");
        DeleteApiKeyRequest interceptedRequest = DeleteApiKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApiKeyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteApiKeyResponse> transformer = DeleteApiKeyConverter.fromResponse();
        AsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApiKeyRequest, DeleteApiKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAuthTokenResponse> deleteAuthToken(DeleteAuthTokenRequest request, AsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse> handler) {
        LOG.trace("Called async deleteAuthToken");
        DeleteAuthTokenRequest interceptedRequest = DeleteAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteAuthTokenResponse> transformer = DeleteAuthTokenConverter.fromResponse();
        AsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAuthTokenRequest, DeleteAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCompartmentResponse> deleteCompartment(DeleteCompartmentRequest request, AsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse> handler) {
        LOG.trace("Called async deleteCompartment");
        DeleteCompartmentRequest interceptedRequest = DeleteCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCompartmentResponse> transformer = DeleteCompartmentConverter.fromResponse();
        AsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCompartmentRequest, DeleteCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCustomerSecretKeyResponse> deleteCustomerSecretKey(DeleteCustomerSecretKeyRequest request, AsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async deleteCustomerSecretKey");
        DeleteCustomerSecretKeyRequest interceptedRequest = DeleteCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCustomerSecretKeyResponse> transformer = DeleteCustomerSecretKeyConverter.fromResponse();
        AsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDynamicGroupResponse> deleteDynamicGroup(DeleteDynamicGroupRequest request, AsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> handler) {
        LOG.trace("Called async deleteDynamicGroup");
        DeleteDynamicGroupRequest interceptedRequest = DeleteDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDynamicGroupResponse> transformer = DeleteDynamicGroupConverter.fromResponse();
        AsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteGroupResponse> deleteGroup(DeleteGroupRequest request, AsyncHandler<DeleteGroupRequest, DeleteGroupResponse> handler) {
        LOG.trace("Called async deleteGroup");
        DeleteGroupRequest interceptedRequest = DeleteGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteGroupResponse> transformer = DeleteGroupConverter.fromResponse();
        AsyncHandler<DeleteGroupRequest, DeleteGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteGroupRequest, DeleteGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteIdentityProviderResponse> deleteIdentityProvider(DeleteIdentityProviderRequest request, AsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> handler) {
        LOG.trace("Called async deleteIdentityProvider");
        DeleteIdentityProviderRequest interceptedRequest = DeleteIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteIdentityProviderResponse> transformer = DeleteIdentityProviderConverter.fromResponse();
        AsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteIdpGroupMappingResponse> deleteIdpGroupMapping(DeleteIdpGroupMappingRequest request, AsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> handler) {
        LOG.trace("Called async deleteIdpGroupMapping");
        DeleteIdpGroupMappingRequest interceptedRequest = DeleteIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteIdpGroupMappingResponse> transformer = DeleteIdpGroupMappingConverter.fromResponse();
        AsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteMfaTotpDeviceResponse> deleteMfaTotpDevice(DeleteMfaTotpDeviceRequest request, AsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async deleteMfaTotpDevice");
        DeleteMfaTotpDeviceRequest interceptedRequest = DeleteMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteMfaTotpDeviceResponse> transformer = DeleteMfaTotpDeviceConverter.fromResponse();
        AsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteNetworkSourceResponse> deleteNetworkSource(DeleteNetworkSourceRequest request, AsyncHandler<DeleteNetworkSourceRequest, DeleteNetworkSourceResponse> handler) {
        LOG.trace("Called async deleteNetworkSource");
        DeleteNetworkSourceRequest interceptedRequest = DeleteNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteNetworkSourceResponse> transformer = DeleteNetworkSourceConverter.fromResponse();
        AsyncHandler<DeleteNetworkSourceRequest, DeleteNetworkSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteNetworkSourceRequest, DeleteNetworkSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteOAuthClientCredentialResponse> deleteOAuthClientCredential(DeleteOAuthClientCredentialRequest request, AsyncHandler<DeleteOAuthClientCredentialRequest, DeleteOAuthClientCredentialResponse> handler) {
        LOG.trace("Called async deleteOAuthClientCredential");
        DeleteOAuthClientCredentialRequest interceptedRequest = DeleteOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteOAuthClientCredentialResponse> transformer = DeleteOAuthClientCredentialConverter.fromResponse();
        AsyncHandler<DeleteOAuthClientCredentialRequest, DeleteOAuthClientCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteOAuthClientCredentialRequest, DeleteOAuthClientCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePolicyResponse> deletePolicy(DeletePolicyRequest request, AsyncHandler<DeletePolicyRequest, DeletePolicyResponse> handler) {
        LOG.trace("Called async deletePolicy");
        DeletePolicyRequest interceptedRequest = DeletePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePolicyResponse> transformer = DeletePolicyConverter.fromResponse();
        AsyncHandler<DeletePolicyRequest, DeletePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePolicyRequest, DeletePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSmtpCredentialResponse> deleteSmtpCredential(DeleteSmtpCredentialRequest request, AsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> handler) {
        LOG.trace("Called async deleteSmtpCredential");
        DeleteSmtpCredentialRequest interceptedRequest = DeleteSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteSmtpCredentialResponse> transformer = DeleteSmtpCredentialConverter.fromResponse();
        AsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSwiftPasswordResponse> deleteSwiftPassword(DeleteSwiftPasswordRequest request, AsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> handler) {
        LOG.trace("Called async deleteSwiftPassword");
        DeleteSwiftPasswordRequest interceptedRequest = DeleteSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteSwiftPasswordResponse> transformer = DeleteSwiftPasswordConverter.fromResponse();
        AsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTagResponse> deleteTag(DeleteTagRequest request, AsyncHandler<DeleteTagRequest, DeleteTagResponse> handler) {
        LOG.trace("Called async deleteTag");
        DeleteTagRequest interceptedRequest = DeleteTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTagResponse> transformer = DeleteTagConverter.fromResponse();
        AsyncHandler<DeleteTagRequest, DeleteTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTagRequest, DeleteTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTagDefaultResponse> deleteTagDefault(DeleteTagDefaultRequest request, AsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse> handler) {
        LOG.trace("Called async deleteTagDefault");
        DeleteTagDefaultRequest interceptedRequest = DeleteTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTagDefaultResponse> transformer = DeleteTagDefaultConverter.fromResponse();
        AsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTagDefaultRequest, DeleteTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTagNamespaceResponse> deleteTagNamespace(DeleteTagNamespaceRequest request, AsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> handler) {
        LOG.trace("Called async deleteTagNamespace");
        DeleteTagNamespaceRequest interceptedRequest = DeleteTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTagNamespaceResponse> transformer = DeleteTagNamespaceConverter.fromResponse();
        AsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request, AsyncHandler<DeleteUserRequest, DeleteUserResponse> handler) {
        LOG.trace("Called async deleteUser");
        DeleteUserRequest interceptedRequest = DeleteUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteUserResponse> transformer = DeleteUserConverter.fromResponse();
        AsyncHandler<DeleteUserRequest, DeleteUserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteUserRequest, DeleteUserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GenerateTotpSeedResponse> generateTotpSeed(GenerateTotpSeedRequest request, AsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse> handler) {
        LOG.trace("Called async generateTotpSeed");
        GenerateTotpSeedRequest interceptedRequest = GenerateTotpSeedConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateTotpSeedConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GenerateTotpSeedResponse> transformer = GenerateTotpSeedConverter.fromResponse();
        AsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GenerateTotpSeedRequest, GenerateTotpSeedResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAuthenticationPolicyResponse> getAuthenticationPolicy(GetAuthenticationPolicyRequest request, AsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> handler) {
        LOG.trace("Called async getAuthenticationPolicy");
        GetAuthenticationPolicyRequest interceptedRequest = GetAuthenticationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetAuthenticationPolicyResponse> transformer = GetAuthenticationPolicyConverter.fromResponse();
        AsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCompartmentResponse> getCompartment(GetCompartmentRequest request, AsyncHandler<GetCompartmentRequest, GetCompartmentResponse> handler) {
        LOG.trace("Called async getCompartment");
        GetCompartmentRequest interceptedRequest = GetCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCompartmentResponse> transformer = GetCompartmentConverter.fromResponse();
        AsyncHandler<GetCompartmentRequest, GetCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCompartmentRequest, GetCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDynamicGroupResponse> getDynamicGroup(GetDynamicGroupRequest request, AsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse> handler) {
        LOG.trace("Called async getDynamicGroup");
        GetDynamicGroupRequest interceptedRequest = GetDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDynamicGroupResponse> transformer = GetDynamicGroupConverter.fromResponse();
        AsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDynamicGroupRequest, GetDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetGroupResponse> getGroup(GetGroupRequest request, AsyncHandler<GetGroupRequest, GetGroupResponse> handler) {
        LOG.trace("Called async getGroup");
        GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse();
        AsyncHandler<GetGroupRequest, GetGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetGroupRequest, GetGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetIdentityProviderResponse> getIdentityProvider(GetIdentityProviderRequest request, AsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse> handler) {
        LOG.trace("Called async getIdentityProvider");
        GetIdentityProviderRequest interceptedRequest = GetIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetIdentityProviderResponse> transformer = GetIdentityProviderConverter.fromResponse();
        AsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetIdentityProviderRequest, GetIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetIdpGroupMappingResponse> getIdpGroupMapping(GetIdpGroupMappingRequest request, AsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> handler) {
        LOG.trace("Called async getIdpGroupMapping");
        GetIdpGroupMappingRequest interceptedRequest = GetIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetIdpGroupMappingResponse> transformer = GetIdpGroupMappingConverter.fromResponse();
        AsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMfaTotpDeviceResponse> getMfaTotpDevice(GetMfaTotpDeviceRequest request, AsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> handler) {
        LOG.trace("Called async getMfaTotpDevice");
        GetMfaTotpDeviceRequest interceptedRequest = GetMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetMfaTotpDeviceResponse> transformer = GetMfaTotpDeviceConverter.fromResponse();
        AsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNetworkSourceResponse> getNetworkSource(GetNetworkSourceRequest request, AsyncHandler<GetNetworkSourceRequest, GetNetworkSourceResponse> handler) {
        LOG.trace("Called async getNetworkSource");
        GetNetworkSourceRequest interceptedRequest = GetNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNetworkSourceResponse> transformer = GetNetworkSourceConverter.fromResponse();
        AsyncHandler<GetNetworkSourceRequest, GetNetworkSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNetworkSourceRequest, GetNetworkSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPolicyResponse> getPolicy(GetPolicyRequest request, AsyncHandler<GetPolicyRequest, GetPolicyResponse> handler) {
        LOG.trace("Called async getPolicy");
        GetPolicyRequest interceptedRequest = GetPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPolicyResponse> transformer = GetPolicyConverter.fromResponse();
        AsyncHandler<GetPolicyRequest, GetPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPolicyRequest, GetPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTagResponse> getTag(GetTagRequest request, AsyncHandler<GetTagRequest, GetTagResponse> handler) {
        LOG.trace("Called async getTag");
        GetTagRequest interceptedRequest = GetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTagResponse> transformer = GetTagConverter.fromResponse();
        AsyncHandler<GetTagRequest, GetTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTagRequest, GetTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTagDefaultResponse> getTagDefault(GetTagDefaultRequest request, AsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse> handler) {
        LOG.trace("Called async getTagDefault");
        GetTagDefaultRequest interceptedRequest = GetTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTagDefaultResponse> transformer = GetTagDefaultConverter.fromResponse();
        AsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTagDefaultRequest, GetTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTagNamespaceResponse> getTagNamespace(GetTagNamespaceRequest request, AsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse> handler) {
        LOG.trace("Called async getTagNamespace");
        GetTagNamespaceRequest interceptedRequest = GetTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTagNamespaceResponse> transformer = GetTagNamespaceConverter.fromResponse();
        AsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTagNamespaceRequest, GetTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTaggingWorkRequestResponse> getTaggingWorkRequest(GetTaggingWorkRequestRequest request, AsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> handler) {
        LOG.trace("Called async getTaggingWorkRequest");
        GetTaggingWorkRequestRequest interceptedRequest = GetTaggingWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaggingWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTaggingWorkRequestResponse> transformer = GetTaggingWorkRequestConverter.fromResponse();
        AsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTenancyResponse> getTenancy(GetTenancyRequest request, AsyncHandler<GetTenancyRequest, GetTenancyResponse> handler) {
        LOG.trace("Called async getTenancy");
        GetTenancyRequest interceptedRequest = GetTenancyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTenancyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTenancyResponse> transformer = GetTenancyConverter.fromResponse();
        AsyncHandler<GetTenancyRequest, GetTenancyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTenancyRequest, GetTenancyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUserResponse> getUser(GetUserRequest request, AsyncHandler<GetUserRequest, GetUserResponse> handler) {
        LOG.trace("Called async getUser");
        GetUserRequest interceptedRequest = GetUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetUserResponse> transformer = GetUserConverter.fromResponse();
        AsyncHandler<GetUserRequest, GetUserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUserRequest, GetUserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUserGroupMembershipResponse> getUserGroupMembership(GetUserGroupMembershipRequest request, AsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> handler) {
        LOG.trace("Called async getUserGroupMembership");
        GetUserGroupMembershipRequest interceptedRequest = GetUserGroupMembershipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserGroupMembershipConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetUserGroupMembershipResponse> transformer = GetUserGroupMembershipConverter.fromResponse();
        AsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUserUIPasswordInformationResponse> getUserUIPasswordInformation(GetUserUIPasswordInformationRequest request, AsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> handler) {
        LOG.trace("Called async getUserUIPasswordInformation");
        GetUserUIPasswordInformationRequest interceptedRequest = GetUserUIPasswordInformationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserUIPasswordInformationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetUserUIPasswordInformationResponse> transformer = GetUserUIPasswordInformationConverter.fromResponse();
        AsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApiKeysResponse> listApiKeys(ListApiKeysRequest request, AsyncHandler<ListApiKeysRequest, ListApiKeysResponse> handler) {
        LOG.trace("Called async listApiKeys");
        ListApiKeysRequest interceptedRequest = ListApiKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApiKeysConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListApiKeysResponse> transformer = ListApiKeysConverter.fromResponse();
        AsyncHandler<ListApiKeysRequest, ListApiKeysResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApiKeysRequest, ListApiKeysResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAuthTokensResponse> listAuthTokens(ListAuthTokensRequest request, AsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse> handler) {
        LOG.trace("Called async listAuthTokens");
        ListAuthTokensRequest interceptedRequest = ListAuthTokensConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAuthTokensConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAuthTokensResponse> transformer = ListAuthTokensConverter.fromResponse();
        AsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAuthTokensRequest, ListAuthTokensResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAvailabilityDomainsResponse> listAvailabilityDomains(ListAvailabilityDomainsRequest request, AsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> handler) {
        LOG.trace("Called async listAvailabilityDomains");
        ListAvailabilityDomainsRequest interceptedRequest = ListAvailabilityDomainsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailabilityDomainsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAvailabilityDomainsResponse> transformer = ListAvailabilityDomainsConverter.fromResponse();
        AsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBulkActionResourceTypesResponse> listBulkActionResourceTypes(ListBulkActionResourceTypesRequest request, AsyncHandler<ListBulkActionResourceTypesRequest, ListBulkActionResourceTypesResponse> handler) {
        LOG.trace("Called async listBulkActionResourceTypes");
        ListBulkActionResourceTypesRequest interceptedRequest = ListBulkActionResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBulkActionResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBulkActionResourceTypesResponse> transformer = ListBulkActionResourceTypesConverter.fromResponse();
        AsyncHandler<ListBulkActionResourceTypesRequest, ListBulkActionResourceTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBulkActionResourceTypesRequest, ListBulkActionResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBulkEditTagsResourceTypesResponse> listBulkEditTagsResourceTypes(ListBulkEditTagsResourceTypesRequest request, AsyncHandler<ListBulkEditTagsResourceTypesRequest, ListBulkEditTagsResourceTypesResponse> handler) {
        LOG.trace("Called async listBulkEditTagsResourceTypes");
        ListBulkEditTagsResourceTypesRequest interceptedRequest = ListBulkEditTagsResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBulkEditTagsResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBulkEditTagsResourceTypesResponse> transformer = ListBulkEditTagsResourceTypesConverter.fromResponse();
        AsyncHandler<ListBulkEditTagsResourceTypesRequest, ListBulkEditTagsResourceTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBulkEditTagsResourceTypesRequest, ListBulkEditTagsResourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCompartmentsResponse> listCompartments(ListCompartmentsRequest request, AsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse> handler) {
        LOG.trace("Called async listCompartments");
        ListCompartmentsRequest interceptedRequest = ListCompartmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCompartmentsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCompartmentsResponse> transformer = ListCompartmentsConverter.fromResponse();
        AsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCompartmentsRequest, ListCompartmentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCostTrackingTagsResponse> listCostTrackingTags(ListCostTrackingTagsRequest request, AsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> handler) {
        LOG.trace("Called async listCostTrackingTags");
        ListCostTrackingTagsRequest interceptedRequest = ListCostTrackingTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCostTrackingTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCostTrackingTagsResponse> transformer = ListCostTrackingTagsConverter.fromResponse();
        AsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCustomerSecretKeysResponse> listCustomerSecretKeys(ListCustomerSecretKeysRequest request, AsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> handler) {
        LOG.trace("Called async listCustomerSecretKeys");
        ListCustomerSecretKeysRequest interceptedRequest = ListCustomerSecretKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomerSecretKeysConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCustomerSecretKeysResponse> transformer = ListCustomerSecretKeysConverter.fromResponse();
        AsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDynamicGroupsResponse> listDynamicGroups(ListDynamicGroupsRequest request, AsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse> handler) {
        LOG.trace("Called async listDynamicGroups");
        ListDynamicGroupsRequest interceptedRequest = ListDynamicGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDynamicGroupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDynamicGroupsResponse> transformer = ListDynamicGroupsConverter.fromResponse();
        AsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDynamicGroupsRequest, ListDynamicGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFaultDomainsResponse> listFaultDomains(ListFaultDomainsRequest request, AsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse> handler) {
        LOG.trace("Called async listFaultDomains");
        ListFaultDomainsRequest interceptedRequest = ListFaultDomainsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFaultDomainsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListFaultDomainsResponse> transformer = ListFaultDomainsConverter.fromResponse();
        AsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFaultDomainsRequest, ListFaultDomainsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListGroupsResponse> listGroups(ListGroupsRequest request, AsyncHandler<ListGroupsRequest, ListGroupsResponse> handler) {
        LOG.trace("Called async listGroups");
        ListGroupsRequest interceptedRequest = ListGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGroupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListGroupsResponse> transformer = ListGroupsConverter.fromResponse();
        AsyncHandler<ListGroupsRequest, ListGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListGroupsRequest, ListGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListIdentityProviderGroupsResponse> listIdentityProviderGroups(ListIdentityProviderGroupsRequest request, AsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> handler) {
        LOG.trace("Called async listIdentityProviderGroups");
        ListIdentityProviderGroupsRequest interceptedRequest = ListIdentityProviderGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdentityProviderGroupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListIdentityProviderGroupsResponse> transformer = ListIdentityProviderGroupsConverter.fromResponse();
        AsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListIdentityProvidersResponse> listIdentityProviders(ListIdentityProvidersRequest request, AsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse> handler) {
        LOG.trace("Called async listIdentityProviders");
        ListIdentityProvidersRequest interceptedRequest = ListIdentityProvidersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdentityProvidersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListIdentityProvidersResponse> transformer = ListIdentityProvidersConverter.fromResponse();
        AsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListIdentityProvidersRequest, ListIdentityProvidersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListIdpGroupMappingsResponse> listIdpGroupMappings(ListIdpGroupMappingsRequest request, AsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> handler) {
        LOG.trace("Called async listIdpGroupMappings");
        ListIdpGroupMappingsRequest interceptedRequest = ListIdpGroupMappingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdpGroupMappingsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListIdpGroupMappingsResponse> transformer = ListIdpGroupMappingsConverter.fromResponse();
        AsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMfaTotpDevicesResponse> listMfaTotpDevices(ListMfaTotpDevicesRequest request, AsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> handler) {
        LOG.trace("Called async listMfaTotpDevices");
        ListMfaTotpDevicesRequest interceptedRequest = ListMfaTotpDevicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMfaTotpDevicesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListMfaTotpDevicesResponse> transformer = ListMfaTotpDevicesConverter.fromResponse();
        AsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNetworkSourcesResponse> listNetworkSources(ListNetworkSourcesRequest request, AsyncHandler<ListNetworkSourcesRequest, ListNetworkSourcesResponse> handler) {
        LOG.trace("Called async listNetworkSources");
        ListNetworkSourcesRequest interceptedRequest = ListNetworkSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkSourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListNetworkSourcesResponse> transformer = ListNetworkSourcesConverter.fromResponse();
        AsyncHandler<ListNetworkSourcesRequest, ListNetworkSourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNetworkSourcesRequest, ListNetworkSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListOAuthClientCredentialsResponse> listOAuthClientCredentials(ListOAuthClientCredentialsRequest request, AsyncHandler<ListOAuthClientCredentialsRequest, ListOAuthClientCredentialsResponse> handler) {
        LOG.trace("Called async listOAuthClientCredentials");
        ListOAuthClientCredentialsRequest interceptedRequest = ListOAuthClientCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOAuthClientCredentialsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListOAuthClientCredentialsResponse> transformer = ListOAuthClientCredentialsConverter.fromResponse();
        AsyncHandler<ListOAuthClientCredentialsRequest, ListOAuthClientCredentialsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListOAuthClientCredentialsRequest, ListOAuthClientCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        LOG.trace("Called async listPolicies");
        ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPoliciesRequest, ListPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRegionSubscriptionsResponse> listRegionSubscriptions(ListRegionSubscriptionsRequest request, AsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> handler) {
        LOG.trace("Called async listRegionSubscriptions");
        ListRegionSubscriptionsRequest interceptedRequest = ListRegionSubscriptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRegionSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRegionSubscriptionsResponse> transformer = ListRegionSubscriptionsConverter.fromResponse();
        AsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRegionsResponse> listRegions(ListRegionsRequest request, AsyncHandler<ListRegionsRequest, ListRegionsResponse> handler) {
        LOG.trace("Called async listRegions");
        ListRegionsRequest interceptedRequest = ListRegionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRegionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRegionsResponse> transformer = ListRegionsConverter.fromResponse();
        AsyncHandler<ListRegionsRequest, ListRegionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRegionsRequest, ListRegionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSmtpCredentialsResponse> listSmtpCredentials(ListSmtpCredentialsRequest request, AsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> handler) {
        LOG.trace("Called async listSmtpCredentials");
        ListSmtpCredentialsRequest interceptedRequest = ListSmtpCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSmtpCredentialsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSmtpCredentialsResponse> transformer = ListSmtpCredentialsConverter.fromResponse();
        AsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSwiftPasswordsResponse> listSwiftPasswords(ListSwiftPasswordsRequest request, AsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> handler) {
        LOG.trace("Called async listSwiftPasswords");
        ListSwiftPasswordsRequest interceptedRequest = ListSwiftPasswordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSwiftPasswordsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSwiftPasswordsResponse> transformer = ListSwiftPasswordsConverter.fromResponse();
        AsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTagDefaultsResponse> listTagDefaults(ListTagDefaultsRequest request, AsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse> handler) {
        LOG.trace("Called async listTagDefaults");
        ListTagDefaultsRequest interceptedRequest = ListTagDefaultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagDefaultsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTagDefaultsResponse> transformer = ListTagDefaultsConverter.fromResponse();
        AsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTagDefaultsRequest, ListTagDefaultsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTagNamespacesResponse> listTagNamespaces(ListTagNamespacesRequest request, AsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse> handler) {
        LOG.trace("Called async listTagNamespaces");
        ListTagNamespacesRequest interceptedRequest = ListTagNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagNamespacesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTagNamespacesResponse> transformer = ListTagNamespacesConverter.fromResponse();
        AsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTagNamespacesRequest, ListTagNamespacesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaggingWorkRequestErrorsResponse> listTaggingWorkRequestErrors(ListTaggingWorkRequestErrorsRequest request, AsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequestErrors");
        ListTaggingWorkRequestErrorsRequest interceptedRequest = ListTaggingWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaggingWorkRequestErrorsResponse> transformer = ListTaggingWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaggingWorkRequestLogsResponse> listTaggingWorkRequestLogs(ListTaggingWorkRequestLogsRequest request, AsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequestLogs");
        ListTaggingWorkRequestLogsRequest interceptedRequest = ListTaggingWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaggingWorkRequestLogsResponse> transformer = ListTaggingWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaggingWorkRequestsResponse> listTaggingWorkRequests(ListTaggingWorkRequestsRequest request, AsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> handler) {
        LOG.trace("Called async listTaggingWorkRequests");
        ListTaggingWorkRequestsRequest interceptedRequest = ListTaggingWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaggingWorkRequestsResponse> transformer = ListTaggingWorkRequestsConverter.fromResponse();
        AsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTagsResponse> listTags(ListTagsRequest request, AsyncHandler<ListTagsRequest, ListTagsResponse> handler) {
        LOG.trace("Called async listTags");
        ListTagsRequest interceptedRequest = ListTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTagsResponse> transformer = ListTagsConverter.fromResponse();
        AsyncHandler<ListTagsRequest, ListTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTagsRequest, ListTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUserGroupMembershipsResponse> listUserGroupMemberships(ListUserGroupMembershipsRequest request, AsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> handler) {
        LOG.trace("Called async listUserGroupMemberships");
        ListUserGroupMembershipsRequest interceptedRequest = ListUserGroupMembershipsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUserGroupMembershipsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListUserGroupMembershipsResponse> transformer = ListUserGroupMembershipsConverter.fromResponse();
        AsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUsersResponse> listUsers(ListUsersRequest request, AsyncHandler<ListUsersRequest, ListUsersResponse> handler) {
        LOG.trace("Called async listUsers");
        ListUsersRequest interceptedRequest = ListUsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUsersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListUsersResponse> transformer = ListUsersConverter.fromResponse();
        AsyncHandler<ListUsersRequest, ListUsersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUsersRequest, ListUsersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<MoveCompartmentResponse> moveCompartment(MoveCompartmentRequest request, AsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse> handler) {
        LOG.trace("Called async moveCompartment");
        MoveCompartmentRequest interceptedRequest = MoveCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MoveCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, MoveCompartmentResponse> transformer = MoveCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<MoveCompartmentRequest, MoveCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RecoverCompartmentResponse> recoverCompartment(RecoverCompartmentRequest request, AsyncHandler<RecoverCompartmentRequest, RecoverCompartmentResponse> handler) {
        LOG.trace("Called async recoverCompartment");
        RecoverCompartmentRequest interceptedRequest = RecoverCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecoverCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RecoverCompartmentResponse> transformer = RecoverCompartmentConverter.fromResponse();
        AsyncHandler<RecoverCompartmentRequest, RecoverCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RecoverCompartmentRequest, RecoverCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveUserFromGroupResponse> removeUserFromGroup(RemoveUserFromGroupRequest request, AsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> handler) {
        LOG.trace("Called async removeUserFromGroup");
        RemoveUserFromGroupRequest interceptedRequest = RemoveUserFromGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveUserFromGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RemoveUserFromGroupResponse> transformer = RemoveUserFromGroupConverter.fromResponse();
        AsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ResetIdpScimClientResponse> resetIdpScimClient(ResetIdpScimClientRequest request, AsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse> handler) {
        LOG.trace("Called async resetIdpScimClient");
        ResetIdpScimClientRequest interceptedRequest = ResetIdpScimClientConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResetIdpScimClientConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ResetIdpScimClientResponse> transformer = ResetIdpScimClientConverter.fromResponse();
        AsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ResetIdpScimClientRequest, ResetIdpScimClientResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAuthTokenResponse> updateAuthToken(UpdateAuthTokenRequest request, AsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse> handler) {
        LOG.trace("Called async updateAuthToken");
        UpdateAuthTokenRequest interceptedRequest = UpdateAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateAuthTokenResponse> transformer = UpdateAuthTokenConverter.fromResponse();
        AsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAuthTokenRequest, UpdateAuthTokenResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAuthenticationPolicyResponse> updateAuthenticationPolicy(UpdateAuthenticationPolicyRequest request, AsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> handler) {
        LOG.trace("Called async updateAuthenticationPolicy");
        UpdateAuthenticationPolicyRequest interceptedRequest = UpdateAuthenticationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateAuthenticationPolicyResponse> transformer = UpdateAuthenticationPolicyConverter.fromResponse();
        AsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCompartmentResponse> updateCompartment(UpdateCompartmentRequest request, AsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse> handler) {
        LOG.trace("Called async updateCompartment");
        UpdateCompartmentRequest interceptedRequest = UpdateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCompartmentResponse> transformer = UpdateCompartmentConverter.fromResponse();
        AsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCompartmentRequest, UpdateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCustomerSecretKeyResponse> updateCustomerSecretKey(UpdateCustomerSecretKeyRequest request, AsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> handler) {
        LOG.trace("Called async updateCustomerSecretKey");
        UpdateCustomerSecretKeyRequest interceptedRequest = UpdateCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCustomerSecretKeyResponse> transformer = UpdateCustomerSecretKeyConverter.fromResponse();
        AsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDynamicGroupResponse> updateDynamicGroup(UpdateDynamicGroupRequest request, AsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> handler) {
        LOG.trace("Called async updateDynamicGroup");
        UpdateDynamicGroupRequest interceptedRequest = UpdateDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDynamicGroupResponse> transformer = UpdateDynamicGroupConverter.fromResponse();
        AsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateGroupResponse> updateGroup(UpdateGroupRequest request, AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handler) {
        LOG.trace("Called async updateGroup");
        UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse();
        AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateGroupRequest, UpdateGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateIdentityProviderResponse> updateIdentityProvider(UpdateIdentityProviderRequest request, AsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> handler) {
        LOG.trace("Called async updateIdentityProvider");
        UpdateIdentityProviderRequest interceptedRequest = UpdateIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateIdentityProviderResponse> transformer = UpdateIdentityProviderConverter.fromResponse();
        AsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateIdpGroupMappingResponse> updateIdpGroupMapping(UpdateIdpGroupMappingRequest request, AsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> handler) {
        LOG.trace("Called async updateIdpGroupMapping");
        UpdateIdpGroupMappingRequest interceptedRequest = UpdateIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateIdpGroupMappingResponse> transformer = UpdateIdpGroupMappingConverter.fromResponse();
        AsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNetworkSourceResponse> updateNetworkSource(UpdateNetworkSourceRequest request, AsyncHandler<UpdateNetworkSourceRequest, UpdateNetworkSourceResponse> handler) {
        LOG.trace("Called async updateNetworkSource");
        UpdateNetworkSourceRequest interceptedRequest = UpdateNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateNetworkSourceResponse> transformer = UpdateNetworkSourceConverter.fromResponse();
        AsyncHandler<UpdateNetworkSourceRequest, UpdateNetworkSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNetworkSourceRequest, UpdateNetworkSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateOAuthClientCredentialResponse> updateOAuthClientCredential(UpdateOAuthClientCredentialRequest request, AsyncHandler<UpdateOAuthClientCredentialRequest, UpdateOAuthClientCredentialResponse> handler) {
        LOG.trace("Called async updateOAuthClientCredential");
        UpdateOAuthClientCredentialRequest interceptedRequest = UpdateOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateOAuthClientCredentialResponse> transformer = UpdateOAuthClientCredentialConverter.fromResponse();
        AsyncHandler<UpdateOAuthClientCredentialRequest, UpdateOAuthClientCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateOAuthClientCredentialRequest, UpdateOAuthClientCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePolicyResponse> updatePolicy(UpdatePolicyRequest request, AsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse> handler) {
        LOG.trace("Called async updatePolicy");
        UpdatePolicyRequest interceptedRequest = UpdatePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdatePolicyResponse> transformer = UpdatePolicyConverter.fromResponse();
        AsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePolicyRequest, UpdatePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSmtpCredentialResponse> updateSmtpCredential(UpdateSmtpCredentialRequest request, AsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> handler) {
        LOG.trace("Called async updateSmtpCredential");
        UpdateSmtpCredentialRequest interceptedRequest = UpdateSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateSmtpCredentialResponse> transformer = UpdateSmtpCredentialConverter.fromResponse();
        AsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSwiftPasswordResponse> updateSwiftPassword(UpdateSwiftPasswordRequest request, AsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> handler) {
        LOG.trace("Called async updateSwiftPassword");
        UpdateSwiftPasswordRequest interceptedRequest = UpdateSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateSwiftPasswordResponse> transformer = UpdateSwiftPasswordConverter.fromResponse();
        AsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTagResponse> updateTag(UpdateTagRequest request, AsyncHandler<UpdateTagRequest, UpdateTagResponse> handler) {
        LOG.trace("Called async updateTag");
        UpdateTagRequest interceptedRequest = UpdateTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTagResponse> transformer = UpdateTagConverter.fromResponse();
        AsyncHandler<UpdateTagRequest, UpdateTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTagRequest, UpdateTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTagDefaultResponse> updateTagDefault(UpdateTagDefaultRequest request, AsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse> handler) {
        LOG.trace("Called async updateTagDefault");
        UpdateTagDefaultRequest interceptedRequest = UpdateTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTagDefaultResponse> transformer = UpdateTagDefaultConverter.fromResponse();
        AsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTagDefaultRequest, UpdateTagDefaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTagNamespaceResponse> updateTagNamespace(UpdateTagNamespaceRequest request, AsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> handler) {
        LOG.trace("Called async updateTagNamespace");
        UpdateTagNamespaceRequest interceptedRequest = UpdateTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTagNamespaceResponse> transformer = UpdateTagNamespaceConverter.fromResponse();
        AsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateUserResponse> updateUser(UpdateUserRequest request, AsyncHandler<UpdateUserRequest, UpdateUserResponse> handler) {
        LOG.trace("Called async updateUser");
        UpdateUserRequest interceptedRequest = UpdateUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateUserResponse> transformer = UpdateUserConverter.fromResponse();
        AsyncHandler<UpdateUserRequest, UpdateUserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateUserRequest, UpdateUserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateUserCapabilitiesResponse> updateUserCapabilities(UpdateUserCapabilitiesRequest request, AsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> handler) {
        LOG.trace("Called async updateUserCapabilities");
        UpdateUserCapabilitiesRequest interceptedRequest = UpdateUserCapabilitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserCapabilitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateUserCapabilitiesResponse> transformer = UpdateUserCapabilitiesConverter.fromResponse();
        AsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateUserStateResponse> updateUserState(UpdateUserStateRequest request, AsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse> handler) {
        LOG.trace("Called async updateUserState");
        UpdateUserStateRequest interceptedRequest = UpdateUserStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserStateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateUserStateResponse> transformer = UpdateUserStateConverter.fromResponse();
        AsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateUserStateRequest, UpdateUserStateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UploadApiKeyResponse> uploadApiKey(UploadApiKeyRequest request, AsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse> handler) {
        LOG.trace("Called async uploadApiKey");
        UploadApiKeyRequest interceptedRequest = UploadApiKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadApiKeyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UploadApiKeyResponse> transformer = UploadApiKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UploadApiKeyRequest, UploadApiKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IdentityAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public IdentityAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new IdentityAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

