/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.IdentityPaginators;
import com.oracle.bmc.identity.IdentityWaiters;
import com.oracle.bmc.identity.internal.http.ActivateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.AddUserToGroupConverter;
import com.oracle.bmc.identity.internal.http.AssembleEffectiveTagSetConverter;
import com.oracle.bmc.identity.internal.http.BulkDeleteResourcesConverter;
import com.oracle.bmc.identity.internal.http.BulkDeleteTagsConverter;
import com.oracle.bmc.identity.internal.http.BulkEditTagsConverter;
import com.oracle.bmc.identity.internal.http.BulkMoveResourcesConverter;
import com.oracle.bmc.identity.internal.http.CascadeDeleteTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.ChangeTagNamespaceCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.CreateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.CreateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.CreateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateGroupConverter;
import com.oracle.bmc.identity.internal.http.CreateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.CreateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.CreateMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.CreateNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.CreateOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.CreateOrResetUIPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreatePolicyConverter;
import com.oracle.bmc.identity.internal.http.CreateRegionSubscriptionConverter;
import com.oracle.bmc.identity.internal.http.CreateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.CreateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.CreateTagConverter;
import com.oracle.bmc.identity.internal.http.CreateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.CreateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.CreateUserConverter;
import com.oracle.bmc.identity.internal.http.DeleteApiKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.DeleteCompartmentConverter;
import com.oracle.bmc.identity.internal.http.DeleteCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.DeleteDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteGroupConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.DeleteIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.DeleteMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.DeleteNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.DeleteOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.DeletePolicyConverter;
import com.oracle.bmc.identity.internal.http.DeleteSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.DeleteSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.DeleteTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.DeleteUserConverter;
import com.oracle.bmc.identity.internal.http.GenerateTotpSeedConverter;
import com.oracle.bmc.identity.internal.http.GetAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetCompartmentConverter;
import com.oracle.bmc.identity.internal.http.GetDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.GetGroupConverter;
import com.oracle.bmc.identity.internal.http.GetIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.GetIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.GetMfaTotpDeviceConverter;
import com.oracle.bmc.identity.internal.http.GetNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.GetPolicyConverter;
import com.oracle.bmc.identity.internal.http.GetTagConverter;
import com.oracle.bmc.identity.internal.http.GetTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.GetTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.GetTaggingWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.GetTenancyConverter;
import com.oracle.bmc.identity.internal.http.GetUserConverter;
import com.oracle.bmc.identity.internal.http.GetUserGroupMembershipConverter;
import com.oracle.bmc.identity.internal.http.GetUserUIPasswordInformationConverter;
import com.oracle.bmc.identity.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.identity.internal.http.ListApiKeysConverter;
import com.oracle.bmc.identity.internal.http.ListAuthTokensConverter;
import com.oracle.bmc.identity.internal.http.ListAvailabilityDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListBulkActionResourceTypesConverter;
import com.oracle.bmc.identity.internal.http.ListBulkEditTagsResourceTypesConverter;
import com.oracle.bmc.identity.internal.http.ListCompartmentsConverter;
import com.oracle.bmc.identity.internal.http.ListCostTrackingTagsConverter;
import com.oracle.bmc.identity.internal.http.ListCustomerSecretKeysConverter;
import com.oracle.bmc.identity.internal.http.ListDynamicGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListFaultDomainsConverter;
import com.oracle.bmc.identity.internal.http.ListGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProviderGroupsConverter;
import com.oracle.bmc.identity.internal.http.ListIdentityProvidersConverter;
import com.oracle.bmc.identity.internal.http.ListIdpGroupMappingsConverter;
import com.oracle.bmc.identity.internal.http.ListMfaTotpDevicesConverter;
import com.oracle.bmc.identity.internal.http.ListNetworkSourcesConverter;
import com.oracle.bmc.identity.internal.http.ListOAuthClientCredentialsConverter;
import com.oracle.bmc.identity.internal.http.ListPoliciesConverter;
import com.oracle.bmc.identity.internal.http.ListRegionSubscriptionsConverter;
import com.oracle.bmc.identity.internal.http.ListRegionsConverter;
import com.oracle.bmc.identity.internal.http.ListSmtpCredentialsConverter;
import com.oracle.bmc.identity.internal.http.ListSwiftPasswordsConverter;
import com.oracle.bmc.identity.internal.http.ListTagDefaultsConverter;
import com.oracle.bmc.identity.internal.http.ListTagNamespacesConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestErrorsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestLogsConverter;
import com.oracle.bmc.identity.internal.http.ListTaggingWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.ListTagsConverter;
import com.oracle.bmc.identity.internal.http.ListUserGroupMembershipsConverter;
import com.oracle.bmc.identity.internal.http.ListUsersConverter;
import com.oracle.bmc.identity.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.identity.internal.http.MoveCompartmentConverter;
import com.oracle.bmc.identity.internal.http.RecoverCompartmentConverter;
import com.oracle.bmc.identity.internal.http.RemoveUserFromGroupConverter;
import com.oracle.bmc.identity.internal.http.ResetIdpScimClientConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthTokenConverter;
import com.oracle.bmc.identity.internal.http.UpdateAuthenticationPolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateCompartmentConverter;
import com.oracle.bmc.identity.internal.http.UpdateCustomerSecretKeyConverter;
import com.oracle.bmc.identity.internal.http.UpdateDynamicGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateGroupConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdentityProviderConverter;
import com.oracle.bmc.identity.internal.http.UpdateIdpGroupMappingConverter;
import com.oracle.bmc.identity.internal.http.UpdateNetworkSourceConverter;
import com.oracle.bmc.identity.internal.http.UpdateOAuthClientCredentialConverter;
import com.oracle.bmc.identity.internal.http.UpdatePolicyConverter;
import com.oracle.bmc.identity.internal.http.UpdateSmtpCredentialConverter;
import com.oracle.bmc.identity.internal.http.UpdateSwiftPasswordConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagDefaultConverter;
import com.oracle.bmc.identity.internal.http.UpdateTagNamespaceConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserCapabilitiesConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserConverter;
import com.oracle.bmc.identity.internal.http.UpdateUserStateConverter;
import com.oracle.bmc.identity.internal.http.UploadApiKeyConverter;
import com.oracle.bmc.identity.requests.ActivateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.AddUserToGroupRequest;
import com.oracle.bmc.identity.requests.AssembleEffectiveTagSetRequest;
import com.oracle.bmc.identity.requests.BulkDeleteResourcesRequest;
import com.oracle.bmc.identity.requests.BulkDeleteTagsRequest;
import com.oracle.bmc.identity.requests.BulkEditTagsRequest;
import com.oracle.bmc.identity.requests.BulkMoveResourcesRequest;
import com.oracle.bmc.identity.requests.CascadeDeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.ChangeTagNamespaceCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateAuthTokenRequest;
import com.oracle.bmc.identity.requests.CreateCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.CreateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.CreateGroupRequest;
import com.oracle.bmc.identity.requests.CreateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.CreateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.CreateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.CreateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.CreateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.CreateOrResetUIPasswordRequest;
import com.oracle.bmc.identity.requests.CreatePolicyRequest;
import com.oracle.bmc.identity.requests.CreateRegionSubscriptionRequest;
import com.oracle.bmc.identity.requests.CreateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.CreateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.CreateTagDefaultRequest;
import com.oracle.bmc.identity.requests.CreateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.CreateTagRequest;
import com.oracle.bmc.identity.requests.CreateUserRequest;
import com.oracle.bmc.identity.requests.DeleteApiKeyRequest;
import com.oracle.bmc.identity.requests.DeleteAuthTokenRequest;
import com.oracle.bmc.identity.requests.DeleteCompartmentRequest;
import com.oracle.bmc.identity.requests.DeleteCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.DeleteDynamicGroupRequest;
import com.oracle.bmc.identity.requests.DeleteGroupRequest;
import com.oracle.bmc.identity.requests.DeleteIdentityProviderRequest;
import com.oracle.bmc.identity.requests.DeleteIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.DeleteMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.DeleteNetworkSourceRequest;
import com.oracle.bmc.identity.requests.DeleteOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.DeletePolicyRequest;
import com.oracle.bmc.identity.requests.DeleteSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.DeleteSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.DeleteTagDefaultRequest;
import com.oracle.bmc.identity.requests.DeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.DeleteTagRequest;
import com.oracle.bmc.identity.requests.DeleteUserRequest;
import com.oracle.bmc.identity.requests.GenerateTotpSeedRequest;
import com.oracle.bmc.identity.requests.GetAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.GetCompartmentRequest;
import com.oracle.bmc.identity.requests.GetDynamicGroupRequest;
import com.oracle.bmc.identity.requests.GetGroupRequest;
import com.oracle.bmc.identity.requests.GetIdentityProviderRequest;
import com.oracle.bmc.identity.requests.GetIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.GetMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.GetNetworkSourceRequest;
import com.oracle.bmc.identity.requests.GetPolicyRequest;
import com.oracle.bmc.identity.requests.GetTagDefaultRequest;
import com.oracle.bmc.identity.requests.GetTagNamespaceRequest;
import com.oracle.bmc.identity.requests.GetTagRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.GetUserGroupMembershipRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.GetUserUIPasswordInformationRequest;
import com.oracle.bmc.identity.requests.GetWorkRequestRequest;
import com.oracle.bmc.identity.requests.ListApiKeysRequest;
import com.oracle.bmc.identity.requests.ListAuthTokensRequest;
import com.oracle.bmc.identity.requests.ListAvailabilityDomainsRequest;
import com.oracle.bmc.identity.requests.ListBulkActionResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListBulkEditTagsResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListCostTrackingTagsRequest;
import com.oracle.bmc.identity.requests.ListCustomerSecretKeysRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListFaultDomainsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListNetworkSourcesRequest;
import com.oracle.bmc.identity.requests.ListOAuthClientCredentialsRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.requests.ListRegionsRequest;
import com.oracle.bmc.identity.requests.ListSmtpCredentialsRequest;
import com.oracle.bmc.identity.requests.ListSwiftPasswordsRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.requests.MoveCompartmentRequest;
import com.oracle.bmc.identity.requests.RecoverCompartmentRequest;
import com.oracle.bmc.identity.requests.RemoveUserFromGroupRequest;
import com.oracle.bmc.identity.requests.ResetIdpScimClientRequest;
import com.oracle.bmc.identity.requests.UpdateAuthTokenRequest;
import com.oracle.bmc.identity.requests.UpdateAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.UpdateCompartmentRequest;
import com.oracle.bmc.identity.requests.UpdateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.UpdateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.UpdateGroupRequest;
import com.oracle.bmc.identity.requests.UpdateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.UpdateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.UpdateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.UpdateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.UpdatePolicyRequest;
import com.oracle.bmc.identity.requests.UpdateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.UpdateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.UpdateTagDefaultRequest;
import com.oracle.bmc.identity.requests.UpdateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.UpdateTagRequest;
import com.oracle.bmc.identity.requests.UpdateUserCapabilitiesRequest;
import com.oracle.bmc.identity.requests.UpdateUserRequest;
import com.oracle.bmc.identity.requests.UpdateUserStateRequest;
import com.oracle.bmc.identity.requests.UploadApiKeyRequest;
import com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.AddUserToGroupResponse;
import com.oracle.bmc.identity.responses.AssembleEffectiveTagSetResponse;
import com.oracle.bmc.identity.responses.BulkDeleteResourcesResponse;
import com.oracle.bmc.identity.responses.BulkDeleteTagsResponse;
import com.oracle.bmc.identity.responses.BulkEditTagsResponse;
import com.oracle.bmc.identity.responses.BulkMoveResourcesResponse;
import com.oracle.bmc.identity.responses.CascadeDeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.ChangeTagNamespaceCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateAuthTokenResponse;
import com.oracle.bmc.identity.responses.CreateCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.CreateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.CreateGroupResponse;
import com.oracle.bmc.identity.responses.CreateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.CreateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.CreateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.CreateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.CreateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.CreateOrResetUIPasswordResponse;
import com.oracle.bmc.identity.responses.CreatePolicyResponse;
import com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse;
import com.oracle.bmc.identity.responses.CreateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.CreateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.CreateTagDefaultResponse;
import com.oracle.bmc.identity.responses.CreateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.CreateTagResponse;
import com.oracle.bmc.identity.responses.CreateUserResponse;
import com.oracle.bmc.identity.responses.DeleteApiKeyResponse;
import com.oracle.bmc.identity.responses.DeleteAuthTokenResponse;
import com.oracle.bmc.identity.responses.DeleteCompartmentResponse;
import com.oracle.bmc.identity.responses.DeleteCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.DeleteDynamicGroupResponse;
import com.oracle.bmc.identity.responses.DeleteGroupResponse;
import com.oracle.bmc.identity.responses.DeleteIdentityProviderResponse;
import com.oracle.bmc.identity.responses.DeleteIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.DeleteMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.DeleteNetworkSourceResponse;
import com.oracle.bmc.identity.responses.DeleteOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.DeletePolicyResponse;
import com.oracle.bmc.identity.responses.DeleteSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.DeleteSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.DeleteTagDefaultResponse;
import com.oracle.bmc.identity.responses.DeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.DeleteTagResponse;
import com.oracle.bmc.identity.responses.DeleteUserResponse;
import com.oracle.bmc.identity.responses.GenerateTotpSeedResponse;
import com.oracle.bmc.identity.responses.GetAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.GetCompartmentResponse;
import com.oracle.bmc.identity.responses.GetDynamicGroupResponse;
import com.oracle.bmc.identity.responses.GetGroupResponse;
import com.oracle.bmc.identity.responses.GetIdentityProviderResponse;
import com.oracle.bmc.identity.responses.GetIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.GetMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.GetNetworkSourceResponse;
import com.oracle.bmc.identity.responses.GetPolicyResponse;
import com.oracle.bmc.identity.responses.GetTagDefaultResponse;
import com.oracle.bmc.identity.responses.GetTagNamespaceResponse;
import com.oracle.bmc.identity.responses.GetTagResponse;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.GetUserGroupMembershipResponse;
import com.oracle.bmc.identity.responses.GetUserResponse;
import com.oracle.bmc.identity.responses.GetUserUIPasswordInformationResponse;
import com.oracle.bmc.identity.responses.GetWorkRequestResponse;
import com.oracle.bmc.identity.responses.ListApiKeysResponse;
import com.oracle.bmc.identity.responses.ListAuthTokensResponse;
import com.oracle.bmc.identity.responses.ListAvailabilityDomainsResponse;
import com.oracle.bmc.identity.responses.ListBulkActionResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListBulkEditTagsResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListCostTrackingTagsResponse;
import com.oracle.bmc.identity.responses.ListCustomerSecretKeysResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListFaultDomainsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListNetworkSourcesResponse;
import com.oracle.bmc.identity.responses.ListOAuthClientCredentialsResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import com.oracle.bmc.identity.responses.ListRegionsResponse;
import com.oracle.bmc.identity.responses.ListSmtpCredentialsResponse;
import com.oracle.bmc.identity.responses.ListSwiftPasswordsResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.identity.responses.MoveCompartmentResponse;
import com.oracle.bmc.identity.responses.RecoverCompartmentResponse;
import com.oracle.bmc.identity.responses.RemoveUserFromGroupResponse;
import com.oracle.bmc.identity.responses.ResetIdpScimClientResponse;
import com.oracle.bmc.identity.responses.UpdateAuthTokenResponse;
import com.oracle.bmc.identity.responses.UpdateAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.UpdateCompartmentResponse;
import com.oracle.bmc.identity.responses.UpdateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.UpdateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.UpdateGroupResponse;
import com.oracle.bmc.identity.responses.UpdateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.UpdateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.UpdateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.UpdatePolicyResponse;
import com.oracle.bmc.identity.responses.UpdateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.UpdateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.UpdateTagDefaultResponse;
import com.oracle.bmc.identity.responses.UpdateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.UpdateTagResponse;
import com.oracle.bmc.identity.responses.UpdateUserCapabilitiesResponse;
import com.oracle.bmc.identity.responses.UpdateUserResponse;
import com.oracle.bmc.identity.responses.UpdateUserStateResponse;
import com.oracle.bmc.identity.responses.UploadApiKeyResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityClient
implements Identity {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("IDENTITY").serviceEndpointPrefix("identity").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final IdentityWaiters waiters;
    private final IdentityPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public IdentityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public IdentityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public IdentityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected IdentityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Identity-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new IdentityWaiters(executorService, this);
        this.paginators = new IdentityPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ActivateMfaTotpDeviceResponse activateMfaTotpDevice(ActivateMfaTotpDeviceRequest request) {
        LOG.trace("Called activateMfaTotpDevice");
        ActivateMfaTotpDeviceRequest interceptedRequest = ActivateMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateMfaTotpDeviceResponse> transformer = ActivateMfaTotpDeviceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ActivateMfaTotpDeviceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateMfaTotpDeviceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getMfaTotpToken(), (BmcRequest)retriedRequest);
                return (ActivateMfaTotpDeviceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AddUserToGroupResponse addUserToGroup(AddUserToGroupRequest request) {
        LOG.trace("Called addUserToGroup");
        AddUserToGroupRequest interceptedRequest = AddUserToGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddUserToGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddUserToGroupResponse> transformer = AddUserToGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddUserToGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddUserToGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddUserToGroupDetails(), (BmcRequest)retriedRequest);
                return (AddUserToGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AssembleEffectiveTagSetResponse assembleEffectiveTagSet(AssembleEffectiveTagSetRequest request) {
        LOG.trace("Called assembleEffectiveTagSet");
        AssembleEffectiveTagSetRequest interceptedRequest = AssembleEffectiveTagSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AssembleEffectiveTagSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AssembleEffectiveTagSetResponse> transformer = AssembleEffectiveTagSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (AssembleEffectiveTagSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AssembleEffectiveTagSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (AssembleEffectiveTagSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkDeleteResourcesResponse bulkDeleteResources(BulkDeleteResourcesRequest request) {
        LOG.trace("Called bulkDeleteResources");
        BulkDeleteResourcesRequest interceptedRequest = BulkDeleteResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkDeleteResourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkDeleteResourcesResponse> transformer = BulkDeleteResourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BulkDeleteResourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BulkDeleteResourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBulkDeleteResourcesDetails(), (BmcRequest)retriedRequest);
                return (BulkDeleteResourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkDeleteTagsResponse bulkDeleteTags(BulkDeleteTagsRequest request) {
        LOG.trace("Called bulkDeleteTags");
        BulkDeleteTagsRequest interceptedRequest = BulkDeleteTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkDeleteTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkDeleteTagsResponse> transformer = BulkDeleteTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BulkDeleteTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BulkDeleteTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBulkDeleteTagsDetails(), (BmcRequest)retriedRequest);
                return (BulkDeleteTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkEditTagsResponse bulkEditTags(BulkEditTagsRequest request) {
        LOG.trace("Called bulkEditTags");
        BulkEditTagsRequest interceptedRequest = BulkEditTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkEditTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkEditTagsResponse> transformer = BulkEditTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BulkEditTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BulkEditTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBulkEditTagsDetails(), (BmcRequest)retriedRequest);
                return (BulkEditTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkMoveResourcesResponse bulkMoveResources(BulkMoveResourcesRequest request) {
        LOG.trace("Called bulkMoveResources");
        BulkMoveResourcesRequest interceptedRequest = BulkMoveResourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkMoveResourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkMoveResourcesResponse> transformer = BulkMoveResourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BulkMoveResourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BulkMoveResourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBulkMoveResourcesDetails(), (BmcRequest)retriedRequest);
                return (BulkMoveResourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CascadeDeleteTagNamespaceResponse cascadeDeleteTagNamespace(CascadeDeleteTagNamespaceRequest request) {
        LOG.trace("Called cascadeDeleteTagNamespace");
        CascadeDeleteTagNamespaceRequest interceptedRequest = CascadeDeleteTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CascadeDeleteTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CascadeDeleteTagNamespaceResponse> transformer = CascadeDeleteTagNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CascadeDeleteTagNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CascadeDeleteTagNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CascadeDeleteTagNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeTagNamespaceCompartmentResponse changeTagNamespaceCompartment(ChangeTagNamespaceCompartmentRequest request) {
        LOG.trace("Called changeTagNamespaceCompartment");
        ChangeTagNamespaceCompartmentRequest interceptedRequest = ChangeTagNamespaceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTagNamespaceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTagNamespaceCompartmentResponse> transformer = ChangeTagNamespaceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeTagNamespaceCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeTagNamespaceCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeTagNamespaceCompartmentDetail(), (BmcRequest)retriedRequest);
                return (ChangeTagNamespaceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAuthTokenResponse createAuthToken(CreateAuthTokenRequest request) {
        LOG.trace("Called createAuthToken");
        CreateAuthTokenRequest interceptedRequest = CreateAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAuthTokenResponse> transformer = CreateAuthTokenConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAuthTokenResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAuthTokenResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAuthTokenDetails(), (BmcRequest)retriedRequest);
                return (CreateAuthTokenResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCompartmentResponse createCompartment(CreateCompartmentRequest request) {
        LOG.trace("Called createCompartment");
        CreateCompartmentRequest interceptedRequest = CreateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCompartmentResponse> transformer = CreateCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCompartmentDetails(), (BmcRequest)retriedRequest);
                return (CreateCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCustomerSecretKeyResponse createCustomerSecretKey(CreateCustomerSecretKeyRequest request) {
        LOG.trace("Called createCustomerSecretKey");
        CreateCustomerSecretKeyRequest interceptedRequest = CreateCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCustomerSecretKeyResponse> transformer = CreateCustomerSecretKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCustomerSecretKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCustomerSecretKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCustomerSecretKeyDetails(), (BmcRequest)retriedRequest);
                return (CreateCustomerSecretKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDynamicGroupResponse createDynamicGroup(CreateDynamicGroupRequest request) {
        LOG.trace("Called createDynamicGroup");
        CreateDynamicGroupRequest interceptedRequest = CreateDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDynamicGroupResponse> transformer = CreateDynamicGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDynamicGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDynamicGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDynamicGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateDynamicGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest request) {
        LOG.trace("Called createGroup");
        CreateGroupRequest interceptedRequest = CreateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateGroupResponse> transformer = CreateGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest request) {
        LOG.trace("Called createIdentityProvider");
        CreateIdentityProviderRequest interceptedRequest = CreateIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateIdentityProviderResponse> transformer = CreateIdentityProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateIdentityProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateIdentityProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateIdentityProviderDetails(), (BmcRequest)retriedRequest);
                return (CreateIdentityProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateIdpGroupMappingResponse createIdpGroupMapping(CreateIdpGroupMappingRequest request) {
        LOG.trace("Called createIdpGroupMapping");
        CreateIdpGroupMappingRequest interceptedRequest = CreateIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateIdpGroupMappingResponse> transformer = CreateIdpGroupMappingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateIdpGroupMappingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateIdpGroupMappingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateIdpGroupMappingDetails(), (BmcRequest)retriedRequest);
                return (CreateIdpGroupMappingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateMfaTotpDeviceResponse createMfaTotpDevice(CreateMfaTotpDeviceRequest request) {
        LOG.trace("Called createMfaTotpDevice");
        CreateMfaTotpDeviceRequest interceptedRequest = CreateMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMfaTotpDeviceResponse> transformer = CreateMfaTotpDeviceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateMfaTotpDeviceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateMfaTotpDeviceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CreateMfaTotpDeviceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateNetworkSourceResponse createNetworkSource(CreateNetworkSourceRequest request) {
        LOG.trace("Called createNetworkSource");
        CreateNetworkSourceRequest interceptedRequest = CreateNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNetworkSourceResponse> transformer = CreateNetworkSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateNetworkSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateNetworkSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateNetworkSourceDetails(), (BmcRequest)retriedRequest);
                return (CreateNetworkSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOAuthClientCredentialResponse createOAuthClientCredential(CreateOAuthClientCredentialRequest request) {
        LOG.trace("Called createOAuthClientCredential");
        CreateOAuthClientCredentialRequest interceptedRequest = CreateOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOAuthClientCredentialResponse> transformer = CreateOAuthClientCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateOAuthClientCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateOAuthClientCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateOAuth2ClientCredentialDetails(), (BmcRequest)retriedRequest);
                return (CreateOAuthClientCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOrResetUIPasswordResponse createOrResetUIPassword(CreateOrResetUIPasswordRequest request) {
        LOG.trace("Called createOrResetUIPassword");
        CreateOrResetUIPasswordRequest interceptedRequest = CreateOrResetUIPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOrResetUIPasswordConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOrResetUIPasswordResponse> transformer = CreateOrResetUIPasswordConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateOrResetUIPasswordResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateOrResetUIPasswordResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CreateOrResetUIPasswordResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest request) {
        LOG.trace("Called createPolicy");
        CreatePolicyRequest interceptedRequest = CreatePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePolicyResponse> transformer = CreatePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePolicyDetails(), (BmcRequest)retriedRequest);
                return (CreatePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRegionSubscriptionResponse createRegionSubscription(CreateRegionSubscriptionRequest request) {
        LOG.trace("Called createRegionSubscription");
        CreateRegionSubscriptionRequest interceptedRequest = CreateRegionSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRegionSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRegionSubscriptionResponse> transformer = CreateRegionSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRegionSubscriptionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRegionSubscriptionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRegionSubscriptionDetails(), (BmcRequest)retriedRequest);
                return (CreateRegionSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSmtpCredentialResponse createSmtpCredential(CreateSmtpCredentialRequest request) {
        LOG.trace("Called createSmtpCredential");
        CreateSmtpCredentialRequest interceptedRequest = CreateSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSmtpCredentialResponse> transformer = CreateSmtpCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSmtpCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSmtpCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSmtpCredentialDetails(), (BmcRequest)retriedRequest);
                return (CreateSmtpCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSwiftPasswordResponse createSwiftPassword(CreateSwiftPasswordRequest request) {
        LOG.trace("Called createSwiftPassword");
        CreateSwiftPasswordRequest interceptedRequest = CreateSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSwiftPasswordResponse> transformer = CreateSwiftPasswordConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateSwiftPasswordResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSwiftPasswordResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSwiftPasswordDetails(), (BmcRequest)retriedRequest);
                return (CreateSwiftPasswordResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTagResponse createTag(CreateTagRequest request) {
        LOG.trace("Called createTag");
        CreateTagRequest interceptedRequest = CreateTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTagResponse> transformer = CreateTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTagDetails(), (BmcRequest)retriedRequest);
                return (CreateTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTagDefaultResponse createTagDefault(CreateTagDefaultRequest request) {
        LOG.trace("Called createTagDefault");
        CreateTagDefaultRequest interceptedRequest = CreateTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTagDefaultResponse> transformer = CreateTagDefaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTagDefaultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTagDefaultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTagDefaultDetails(), (BmcRequest)retriedRequest);
                return (CreateTagDefaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTagNamespaceResponse createTagNamespace(CreateTagNamespaceRequest request) {
        LOG.trace("Called createTagNamespace");
        CreateTagNamespaceRequest interceptedRequest = CreateTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTagNamespaceResponse> transformer = CreateTagNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTagNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTagNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTagNamespaceDetails(), (BmcRequest)retriedRequest);
                return (CreateTagNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest request) {
        LOG.trace("Called createUser");
        CreateUserRequest interceptedRequest = CreateUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateUserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateUserResponse> transformer = CreateUserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateUserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateUserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateUserDetails(), (BmcRequest)retriedRequest);
                return (CreateUserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest request) {
        LOG.trace("Called deleteApiKey");
        DeleteApiKeyRequest interceptedRequest = DeleteApiKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApiKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApiKeyResponse> transformer = DeleteApiKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteApiKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteApiKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteApiKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAuthTokenResponse deleteAuthToken(DeleteAuthTokenRequest request) {
        LOG.trace("Called deleteAuthToken");
        DeleteAuthTokenRequest interceptedRequest = DeleteAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAuthTokenResponse> transformer = DeleteAuthTokenConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAuthTokenResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAuthTokenResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAuthTokenResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCompartmentResponse deleteCompartment(DeleteCompartmentRequest request) {
        LOG.trace("Called deleteCompartment");
        DeleteCompartmentRequest interceptedRequest = DeleteCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCompartmentResponse> transformer = DeleteCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCustomerSecretKeyResponse deleteCustomerSecretKey(DeleteCustomerSecretKeyRequest request) {
        LOG.trace("Called deleteCustomerSecretKey");
        DeleteCustomerSecretKeyRequest interceptedRequest = DeleteCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCustomerSecretKeyResponse> transformer = DeleteCustomerSecretKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCustomerSecretKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCustomerSecretKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCustomerSecretKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDynamicGroupResponse deleteDynamicGroup(DeleteDynamicGroupRequest request) {
        LOG.trace("Called deleteDynamicGroup");
        DeleteDynamicGroupRequest interceptedRequest = DeleteDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDynamicGroupResponse> transformer = DeleteDynamicGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDynamicGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDynamicGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDynamicGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest request) {
        LOG.trace("Called deleteGroup");
        DeleteGroupRequest interceptedRequest = DeleteGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteGroupResponse> transformer = DeleteGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest request) {
        LOG.trace("Called deleteIdentityProvider");
        DeleteIdentityProviderRequest interceptedRequest = DeleteIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteIdentityProviderResponse> transformer = DeleteIdentityProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteIdentityProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteIdentityProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteIdentityProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteIdpGroupMappingResponse deleteIdpGroupMapping(DeleteIdpGroupMappingRequest request) {
        LOG.trace("Called deleteIdpGroupMapping");
        DeleteIdpGroupMappingRequest interceptedRequest = DeleteIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteIdpGroupMappingResponse> transformer = DeleteIdpGroupMappingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteIdpGroupMappingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteIdpGroupMappingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteIdpGroupMappingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteMfaTotpDeviceResponse deleteMfaTotpDevice(DeleteMfaTotpDeviceRequest request) {
        LOG.trace("Called deleteMfaTotpDevice");
        DeleteMfaTotpDeviceRequest interceptedRequest = DeleteMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMfaTotpDeviceResponse> transformer = DeleteMfaTotpDeviceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteMfaTotpDeviceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteMfaTotpDeviceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteMfaTotpDeviceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteNetworkSourceResponse deleteNetworkSource(DeleteNetworkSourceRequest request) {
        LOG.trace("Called deleteNetworkSource");
        DeleteNetworkSourceRequest interceptedRequest = DeleteNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNetworkSourceResponse> transformer = DeleteNetworkSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteNetworkSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteNetworkSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteNetworkSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteOAuthClientCredentialResponse deleteOAuthClientCredential(DeleteOAuthClientCredentialRequest request) {
        LOG.trace("Called deleteOAuthClientCredential");
        DeleteOAuthClientCredentialRequest interceptedRequest = DeleteOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOAuthClientCredentialResponse> transformer = DeleteOAuthClientCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteOAuthClientCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteOAuthClientCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteOAuthClientCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest request) {
        LOG.trace("Called deletePolicy");
        DeletePolicyRequest interceptedRequest = DeletePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePolicyResponse> transformer = DeletePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSmtpCredentialResponse deleteSmtpCredential(DeleteSmtpCredentialRequest request) {
        LOG.trace("Called deleteSmtpCredential");
        DeleteSmtpCredentialRequest interceptedRequest = DeleteSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSmtpCredentialResponse> transformer = DeleteSmtpCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSmtpCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSmtpCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSmtpCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSwiftPasswordResponse deleteSwiftPassword(DeleteSwiftPasswordRequest request) {
        LOG.trace("Called deleteSwiftPassword");
        DeleteSwiftPasswordRequest interceptedRequest = DeleteSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSwiftPasswordResponse> transformer = DeleteSwiftPasswordConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSwiftPasswordResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSwiftPasswordResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSwiftPasswordResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTagResponse deleteTag(DeleteTagRequest request) {
        LOG.trace("Called deleteTag");
        DeleteTagRequest interceptedRequest = DeleteTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTagResponse> transformer = DeleteTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTagDefaultResponse deleteTagDefault(DeleteTagDefaultRequest request) {
        LOG.trace("Called deleteTagDefault");
        DeleteTagDefaultRequest interceptedRequest = DeleteTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTagDefaultResponse> transformer = DeleteTagDefaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTagDefaultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTagDefaultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTagDefaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTagNamespaceResponse deleteTagNamespace(DeleteTagNamespaceRequest request) {
        LOG.trace("Called deleteTagNamespace");
        DeleteTagNamespaceRequest interceptedRequest = DeleteTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTagNamespaceResponse> transformer = DeleteTagNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTagNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTagNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTagNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest request) {
        LOG.trace("Called deleteUser");
        DeleteUserRequest interceptedRequest = DeleteUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUserResponse> transformer = DeleteUserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteUserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteUserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteUserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateTotpSeedResponse generateTotpSeed(GenerateTotpSeedRequest request) {
        LOG.trace("Called generateTotpSeed");
        GenerateTotpSeedRequest interceptedRequest = GenerateTotpSeedConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateTotpSeedConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateTotpSeedResponse> transformer = GenerateTotpSeedConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GenerateTotpSeedResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GenerateTotpSeedResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (GenerateTotpSeedResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAuthenticationPolicyResponse getAuthenticationPolicy(GetAuthenticationPolicyRequest request) {
        LOG.trace("Called getAuthenticationPolicy");
        GetAuthenticationPolicyRequest interceptedRequest = GetAuthenticationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAuthenticationPolicyResponse> transformer = GetAuthenticationPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAuthenticationPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAuthenticationPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAuthenticationPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCompartmentResponse getCompartment(GetCompartmentRequest request) {
        LOG.trace("Called getCompartment");
        GetCompartmentRequest interceptedRequest = GetCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCompartmentResponse> transformer = GetCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDynamicGroupResponse getDynamicGroup(GetDynamicGroupRequest request) {
        LOG.trace("Called getDynamicGroup");
        GetDynamicGroupRequest interceptedRequest = GetDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDynamicGroupResponse> transformer = GetDynamicGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDynamicGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDynamicGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDynamicGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetGroupResponse getGroup(GetGroupRequest request) {
        LOG.trace("Called getGroup");
        GetGroupRequest interceptedRequest = GetGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetGroupResponse> transformer = GetGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIdentityProviderResponse getIdentityProvider(GetIdentityProviderRequest request) {
        LOG.trace("Called getIdentityProvider");
        GetIdentityProviderRequest interceptedRequest = GetIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIdentityProviderResponse> transformer = GetIdentityProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetIdentityProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetIdentityProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetIdentityProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIdpGroupMappingResponse getIdpGroupMapping(GetIdpGroupMappingRequest request) {
        LOG.trace("Called getIdpGroupMapping");
        GetIdpGroupMappingRequest interceptedRequest = GetIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIdpGroupMappingResponse> transformer = GetIdpGroupMappingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetIdpGroupMappingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetIdpGroupMappingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetIdpGroupMappingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMfaTotpDeviceResponse getMfaTotpDevice(GetMfaTotpDeviceRequest request) {
        LOG.trace("Called getMfaTotpDevice");
        GetMfaTotpDeviceRequest interceptedRequest = GetMfaTotpDeviceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMfaTotpDeviceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMfaTotpDeviceResponse> transformer = GetMfaTotpDeviceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetMfaTotpDeviceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMfaTotpDeviceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMfaTotpDeviceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNetworkSourceResponse getNetworkSource(GetNetworkSourceRequest request) {
        LOG.trace("Called getNetworkSource");
        GetNetworkSourceRequest interceptedRequest = GetNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkSourceResponse> transformer = GetNetworkSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetNetworkSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNetworkSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNetworkSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest request) {
        LOG.trace("Called getPolicy");
        GetPolicyRequest interceptedRequest = GetPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPolicyResponse> transformer = GetPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTagResponse getTag(GetTagRequest request) {
        LOG.trace("Called getTag");
        GetTagRequest interceptedRequest = GetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTagResponse> transformer = GetTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTagDefaultResponse getTagDefault(GetTagDefaultRequest request) {
        LOG.trace("Called getTagDefault");
        GetTagDefaultRequest interceptedRequest = GetTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTagDefaultResponse> transformer = GetTagDefaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTagDefaultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTagDefaultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTagDefaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTagNamespaceResponse getTagNamespace(GetTagNamespaceRequest request) {
        LOG.trace("Called getTagNamespace");
        GetTagNamespaceRequest interceptedRequest = GetTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTagNamespaceResponse> transformer = GetTagNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTagNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTagNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTagNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTaggingWorkRequestResponse getTaggingWorkRequest(GetTaggingWorkRequestRequest request) {
        LOG.trace("Called getTaggingWorkRequest");
        GetTaggingWorkRequestRequest interceptedRequest = GetTaggingWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaggingWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTaggingWorkRequestResponse> transformer = GetTaggingWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTaggingWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTaggingWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTaggingWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTenancyResponse getTenancy(GetTenancyRequest request) {
        LOG.trace("Called getTenancy");
        GetTenancyRequest interceptedRequest = GetTenancyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTenancyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTenancyResponse> transformer = GetTenancyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTenancyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTenancyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTenancyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUserResponse getUser(GetUserRequest request) {
        LOG.trace("Called getUser");
        GetUserRequest interceptedRequest = GetUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUserResponse> transformer = GetUserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetUserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetUserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetUserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUserGroupMembershipResponse getUserGroupMembership(GetUserGroupMembershipRequest request) {
        LOG.trace("Called getUserGroupMembership");
        GetUserGroupMembershipRequest interceptedRequest = GetUserGroupMembershipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserGroupMembershipConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUserGroupMembershipResponse> transformer = GetUserGroupMembershipConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetUserGroupMembershipResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetUserGroupMembershipResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetUserGroupMembershipResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUserUIPasswordInformationResponse getUserUIPasswordInformation(GetUserUIPasswordInformationRequest request) {
        LOG.trace("Called getUserUIPasswordInformation");
        GetUserUIPasswordInformationRequest interceptedRequest = GetUserUIPasswordInformationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUserUIPasswordInformationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUserUIPasswordInformationResponse> transformer = GetUserUIPasswordInformationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetUserUIPasswordInformationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetUserUIPasswordInformationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetUserUIPasswordInformationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest request) {
        LOG.trace("Called listApiKeys");
        ListApiKeysRequest interceptedRequest = ListApiKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApiKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApiKeysResponse> transformer = ListApiKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApiKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApiKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApiKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAuthTokensResponse listAuthTokens(ListAuthTokensRequest request) {
        LOG.trace("Called listAuthTokens");
        ListAuthTokensRequest interceptedRequest = ListAuthTokensConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAuthTokensConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAuthTokensResponse> transformer = ListAuthTokensConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAuthTokensResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAuthTokensResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAuthTokensResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAvailabilityDomainsResponse listAvailabilityDomains(ListAvailabilityDomainsRequest request) {
        LOG.trace("Called listAvailabilityDomains");
        ListAvailabilityDomainsRequest interceptedRequest = ListAvailabilityDomainsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailabilityDomainsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailabilityDomainsResponse> transformer = ListAvailabilityDomainsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAvailabilityDomainsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailabilityDomainsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailabilityDomainsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBulkActionResourceTypesResponse listBulkActionResourceTypes(ListBulkActionResourceTypesRequest request) {
        LOG.trace("Called listBulkActionResourceTypes");
        ListBulkActionResourceTypesRequest interceptedRequest = ListBulkActionResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBulkActionResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBulkActionResourceTypesResponse> transformer = ListBulkActionResourceTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBulkActionResourceTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBulkActionResourceTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBulkActionResourceTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBulkEditTagsResourceTypesResponse listBulkEditTagsResourceTypes(ListBulkEditTagsResourceTypesRequest request) {
        LOG.trace("Called listBulkEditTagsResourceTypes");
        ListBulkEditTagsResourceTypesRequest interceptedRequest = ListBulkEditTagsResourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBulkEditTagsResourceTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBulkEditTagsResourceTypesResponse> transformer = ListBulkEditTagsResourceTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBulkEditTagsResourceTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBulkEditTagsResourceTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBulkEditTagsResourceTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCompartmentsResponse listCompartments(ListCompartmentsRequest request) {
        LOG.trace("Called listCompartments");
        ListCompartmentsRequest interceptedRequest = ListCompartmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCompartmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCompartmentsResponse> transformer = ListCompartmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCompartmentsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCompartmentsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCompartmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCostTrackingTagsResponse listCostTrackingTags(ListCostTrackingTagsRequest request) {
        LOG.trace("Called listCostTrackingTags");
        ListCostTrackingTagsRequest interceptedRequest = ListCostTrackingTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCostTrackingTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCostTrackingTagsResponse> transformer = ListCostTrackingTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCostTrackingTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCostTrackingTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCostTrackingTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCustomerSecretKeysResponse listCustomerSecretKeys(ListCustomerSecretKeysRequest request) {
        LOG.trace("Called listCustomerSecretKeys");
        ListCustomerSecretKeysRequest interceptedRequest = ListCustomerSecretKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomerSecretKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCustomerSecretKeysResponse> transformer = ListCustomerSecretKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCustomerSecretKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCustomerSecretKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCustomerSecretKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDynamicGroupsResponse listDynamicGroups(ListDynamicGroupsRequest request) {
        LOG.trace("Called listDynamicGroups");
        ListDynamicGroupsRequest interceptedRequest = ListDynamicGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDynamicGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDynamicGroupsResponse> transformer = ListDynamicGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDynamicGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDynamicGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDynamicGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFaultDomainsResponse listFaultDomains(ListFaultDomainsRequest request) {
        LOG.trace("Called listFaultDomains");
        ListFaultDomainsRequest interceptedRequest = ListFaultDomainsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFaultDomainsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFaultDomainsResponse> transformer = ListFaultDomainsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListFaultDomainsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFaultDomainsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFaultDomainsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest request) {
        LOG.trace("Called listGroups");
        ListGroupsRequest interceptedRequest = ListGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListGroupsResponse> transformer = ListGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIdentityProviderGroupsResponse listIdentityProviderGroups(ListIdentityProviderGroupsRequest request) {
        LOG.trace("Called listIdentityProviderGroups");
        ListIdentityProviderGroupsRequest interceptedRequest = ListIdentityProviderGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdentityProviderGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIdentityProviderGroupsResponse> transformer = ListIdentityProviderGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListIdentityProviderGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListIdentityProviderGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListIdentityProviderGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest request) {
        LOG.trace("Called listIdentityProviders");
        ListIdentityProvidersRequest interceptedRequest = ListIdentityProvidersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdentityProvidersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIdentityProvidersResponse> transformer = ListIdentityProvidersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListIdentityProvidersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListIdentityProvidersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListIdentityProvidersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIdpGroupMappingsResponse listIdpGroupMappings(ListIdpGroupMappingsRequest request) {
        LOG.trace("Called listIdpGroupMappings");
        ListIdpGroupMappingsRequest interceptedRequest = ListIdpGroupMappingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIdpGroupMappingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIdpGroupMappingsResponse> transformer = ListIdpGroupMappingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListIdpGroupMappingsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListIdpGroupMappingsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListIdpGroupMappingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMfaTotpDevicesResponse listMfaTotpDevices(ListMfaTotpDevicesRequest request) {
        LOG.trace("Called listMfaTotpDevices");
        ListMfaTotpDevicesRequest interceptedRequest = ListMfaTotpDevicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMfaTotpDevicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMfaTotpDevicesResponse> transformer = ListMfaTotpDevicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListMfaTotpDevicesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMfaTotpDevicesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMfaTotpDevicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkSourcesResponse listNetworkSources(ListNetworkSourcesRequest request) {
        LOG.trace("Called listNetworkSources");
        ListNetworkSourcesRequest interceptedRequest = ListNetworkSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkSourcesResponse> transformer = ListNetworkSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNetworkSourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNetworkSourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNetworkSourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListOAuthClientCredentialsResponse listOAuthClientCredentials(ListOAuthClientCredentialsRequest request) {
        LOG.trace("Called listOAuthClientCredentials");
        ListOAuthClientCredentialsRequest interceptedRequest = ListOAuthClientCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOAuthClientCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOAuthClientCredentialsResponse> transformer = ListOAuthClientCredentialsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListOAuthClientCredentialsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListOAuthClientCredentialsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListOAuthClientCredentialsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest request) {
        LOG.trace("Called listPolicies");
        ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRegionSubscriptionsResponse listRegionSubscriptions(ListRegionSubscriptionsRequest request) {
        LOG.trace("Called listRegionSubscriptions");
        ListRegionSubscriptionsRequest interceptedRequest = ListRegionSubscriptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRegionSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRegionSubscriptionsResponse> transformer = ListRegionSubscriptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRegionSubscriptionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRegionSubscriptionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRegionSubscriptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRegionsResponse listRegions(ListRegionsRequest request) {
        LOG.trace("Called listRegions");
        ListRegionsRequest interceptedRequest = ListRegionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRegionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRegionsResponse> transformer = ListRegionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRegionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRegionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRegionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSmtpCredentialsResponse listSmtpCredentials(ListSmtpCredentialsRequest request) {
        LOG.trace("Called listSmtpCredentials");
        ListSmtpCredentialsRequest interceptedRequest = ListSmtpCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSmtpCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSmtpCredentialsResponse> transformer = ListSmtpCredentialsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSmtpCredentialsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSmtpCredentialsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSmtpCredentialsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSwiftPasswordsResponse listSwiftPasswords(ListSwiftPasswordsRequest request) {
        LOG.trace("Called listSwiftPasswords");
        ListSwiftPasswordsRequest interceptedRequest = ListSwiftPasswordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSwiftPasswordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSwiftPasswordsResponse> transformer = ListSwiftPasswordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSwiftPasswordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSwiftPasswordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSwiftPasswordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTagDefaultsResponse listTagDefaults(ListTagDefaultsRequest request) {
        LOG.trace("Called listTagDefaults");
        ListTagDefaultsRequest interceptedRequest = ListTagDefaultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagDefaultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTagDefaultsResponse> transformer = ListTagDefaultsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTagDefaultsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTagDefaultsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTagDefaultsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTagNamespacesResponse listTagNamespaces(ListTagNamespacesRequest request) {
        LOG.trace("Called listTagNamespaces");
        ListTagNamespacesRequest interceptedRequest = ListTagNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagNamespacesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTagNamespacesResponse> transformer = ListTagNamespacesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTagNamespacesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTagNamespacesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTagNamespacesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaggingWorkRequestErrorsResponse listTaggingWorkRequestErrors(ListTaggingWorkRequestErrorsRequest request) {
        LOG.trace("Called listTaggingWorkRequestErrors");
        ListTaggingWorkRequestErrorsRequest interceptedRequest = ListTaggingWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaggingWorkRequestErrorsResponse> transformer = ListTaggingWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaggingWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaggingWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaggingWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaggingWorkRequestLogsResponse listTaggingWorkRequestLogs(ListTaggingWorkRequestLogsRequest request) {
        LOG.trace("Called listTaggingWorkRequestLogs");
        ListTaggingWorkRequestLogsRequest interceptedRequest = ListTaggingWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaggingWorkRequestLogsResponse> transformer = ListTaggingWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaggingWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaggingWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaggingWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaggingWorkRequestsResponse listTaggingWorkRequests(ListTaggingWorkRequestsRequest request) {
        LOG.trace("Called listTaggingWorkRequests");
        ListTaggingWorkRequestsRequest interceptedRequest = ListTaggingWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaggingWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaggingWorkRequestsResponse> transformer = ListTaggingWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaggingWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaggingWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaggingWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest request) {
        LOG.trace("Called listTags");
        ListTagsRequest interceptedRequest = ListTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTagsResponse> transformer = ListTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUserGroupMembershipsResponse listUserGroupMemberships(ListUserGroupMembershipsRequest request) {
        LOG.trace("Called listUserGroupMemberships");
        ListUserGroupMembershipsRequest interceptedRequest = ListUserGroupMembershipsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUserGroupMembershipsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUserGroupMembershipsResponse> transformer = ListUserGroupMembershipsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUserGroupMembershipsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUserGroupMembershipsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUserGroupMembershipsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest request) {
        LOG.trace("Called listUsers");
        ListUsersRequest interceptedRequest = ListUsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUsersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUsersResponse> transformer = ListUsersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUsersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUsersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUsersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public MoveCompartmentResponse moveCompartment(MoveCompartmentRequest request) {
        LOG.trace("Called moveCompartment");
        MoveCompartmentRequest interceptedRequest = MoveCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MoveCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, MoveCompartmentResponse> transformer = MoveCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (MoveCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (MoveCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getMoveCompartmentDetails(), (BmcRequest)retriedRequest);
                return (MoveCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RecoverCompartmentResponse recoverCompartment(RecoverCompartmentRequest request) {
        LOG.trace("Called recoverCompartment");
        RecoverCompartmentRequest interceptedRequest = RecoverCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecoverCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RecoverCompartmentResponse> transformer = RecoverCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RecoverCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RecoverCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RecoverCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveUserFromGroupResponse removeUserFromGroup(RemoveUserFromGroupRequest request) {
        LOG.trace("Called removeUserFromGroup");
        RemoveUserFromGroupRequest interceptedRequest = RemoveUserFromGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveUserFromGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveUserFromGroupResponse> transformer = RemoveUserFromGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RemoveUserFromGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveUserFromGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (RemoveUserFromGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResetIdpScimClientResponse resetIdpScimClient(ResetIdpScimClientRequest request) {
        LOG.trace("Called resetIdpScimClient");
        ResetIdpScimClientRequest interceptedRequest = ResetIdpScimClientConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResetIdpScimClientConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ResetIdpScimClientResponse> transformer = ResetIdpScimClientConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ResetIdpScimClientResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ResetIdpScimClientResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ResetIdpScimClientResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAuthTokenResponse updateAuthToken(UpdateAuthTokenRequest request) {
        LOG.trace("Called updateAuthToken");
        UpdateAuthTokenRequest interceptedRequest = UpdateAuthTokenConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAuthTokenConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAuthTokenResponse> transformer = UpdateAuthTokenConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAuthTokenResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAuthTokenResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAuthTokenDetails(), (BmcRequest)retriedRequest);
                return (UpdateAuthTokenResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAuthenticationPolicyResponse updateAuthenticationPolicy(UpdateAuthenticationPolicyRequest request) {
        LOG.trace("Called updateAuthenticationPolicy");
        UpdateAuthenticationPolicyRequest interceptedRequest = UpdateAuthenticationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAuthenticationPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAuthenticationPolicyResponse> transformer = UpdateAuthenticationPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAuthenticationPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAuthenticationPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAuthenticationPolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdateAuthenticationPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCompartmentResponse updateCompartment(UpdateCompartmentRequest request) {
        LOG.trace("Called updateCompartment");
        UpdateCompartmentRequest interceptedRequest = UpdateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCompartmentResponse> transformer = UpdateCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCompartmentDetails(), (BmcRequest)retriedRequest);
                return (UpdateCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCustomerSecretKeyResponse updateCustomerSecretKey(UpdateCustomerSecretKeyRequest request) {
        LOG.trace("Called updateCustomerSecretKey");
        UpdateCustomerSecretKeyRequest interceptedRequest = UpdateCustomerSecretKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomerSecretKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCustomerSecretKeyResponse> transformer = UpdateCustomerSecretKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCustomerSecretKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCustomerSecretKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCustomerSecretKeyDetails(), (BmcRequest)retriedRequest);
                return (UpdateCustomerSecretKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDynamicGroupResponse updateDynamicGroup(UpdateDynamicGroupRequest request) {
        LOG.trace("Called updateDynamicGroup");
        UpdateDynamicGroupRequest interceptedRequest = UpdateDynamicGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDynamicGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDynamicGroupResponse> transformer = UpdateDynamicGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDynamicGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDynamicGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDynamicGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateDynamicGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest request) {
        LOG.trace("Called updateGroup");
        UpdateGroupRequest interceptedRequest = UpdateGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateGroupResponse> transformer = UpdateGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest request) {
        LOG.trace("Called updateIdentityProvider");
        UpdateIdentityProviderRequest interceptedRequest = UpdateIdentityProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIdentityProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIdentityProviderResponse> transformer = UpdateIdentityProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateIdentityProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateIdentityProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateIdentityProviderDetails(), (BmcRequest)retriedRequest);
                return (UpdateIdentityProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIdpGroupMappingResponse updateIdpGroupMapping(UpdateIdpGroupMappingRequest request) {
        LOG.trace("Called updateIdpGroupMapping");
        UpdateIdpGroupMappingRequest interceptedRequest = UpdateIdpGroupMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIdpGroupMappingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIdpGroupMappingResponse> transformer = UpdateIdpGroupMappingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateIdpGroupMappingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateIdpGroupMappingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateIdpGroupMappingDetails(), (BmcRequest)retriedRequest);
                return (UpdateIdpGroupMappingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkSourceResponse updateNetworkSource(UpdateNetworkSourceRequest request) {
        LOG.trace("Called updateNetworkSource");
        UpdateNetworkSourceRequest interceptedRequest = UpdateNetworkSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSourceResponse> transformer = UpdateNetworkSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateNetworkSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNetworkSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNetworkSourceDetails(), (BmcRequest)retriedRequest);
                return (UpdateNetworkSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateOAuthClientCredentialResponse updateOAuthClientCredential(UpdateOAuthClientCredentialRequest request) {
        LOG.trace("Called updateOAuthClientCredential");
        UpdateOAuthClientCredentialRequest interceptedRequest = UpdateOAuthClientCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOAuthClientCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOAuthClientCredentialResponse> transformer = UpdateOAuthClientCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateOAuthClientCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateOAuthClientCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateOAuth2ClientCredentialDetails(), (BmcRequest)retriedRequest);
                return (UpdateOAuthClientCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePolicyResponse updatePolicy(UpdatePolicyRequest request) {
        LOG.trace("Called updatePolicy");
        UpdatePolicyRequest interceptedRequest = UpdatePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePolicyResponse> transformer = UpdatePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdatePolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdatePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSmtpCredentialResponse updateSmtpCredential(UpdateSmtpCredentialRequest request) {
        LOG.trace("Called updateSmtpCredential");
        UpdateSmtpCredentialRequest interceptedRequest = UpdateSmtpCredentialConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSmtpCredentialConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSmtpCredentialResponse> transformer = UpdateSmtpCredentialConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSmtpCredentialResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSmtpCredentialResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSmtpCredentialDetails(), (BmcRequest)retriedRequest);
                return (UpdateSmtpCredentialResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSwiftPasswordResponse updateSwiftPassword(UpdateSwiftPasswordRequest request) {
        LOG.trace("Called updateSwiftPassword");
        UpdateSwiftPasswordRequest interceptedRequest = UpdateSwiftPasswordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSwiftPasswordConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSwiftPasswordResponse> transformer = UpdateSwiftPasswordConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSwiftPasswordResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSwiftPasswordResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSwiftPasswordDetails(), (BmcRequest)retriedRequest);
                return (UpdateSwiftPasswordResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTagResponse updateTag(UpdateTagRequest request) {
        LOG.trace("Called updateTag");
        UpdateTagRequest interceptedRequest = UpdateTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTagResponse> transformer = UpdateTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTagDetails(), (BmcRequest)retriedRequest);
                return (UpdateTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTagDefaultResponse updateTagDefault(UpdateTagDefaultRequest request) {
        LOG.trace("Called updateTagDefault");
        UpdateTagDefaultRequest interceptedRequest = UpdateTagDefaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagDefaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTagDefaultResponse> transformer = UpdateTagDefaultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTagDefaultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTagDefaultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTagDefaultDetails(), (BmcRequest)retriedRequest);
                return (UpdateTagDefaultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTagNamespaceResponse updateTagNamespace(UpdateTagNamespaceRequest request) {
        LOG.trace("Called updateTagNamespace");
        UpdateTagNamespaceRequest interceptedRequest = UpdateTagNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTagNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTagNamespaceResponse> transformer = UpdateTagNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTagNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTagNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTagNamespaceDetails(), (BmcRequest)retriedRequest);
                return (UpdateTagNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest request) {
        LOG.trace("Called updateUser");
        UpdateUserRequest interceptedRequest = UpdateUserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateUserResponse> transformer = UpdateUserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateUserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateUserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateUserDetails(), (BmcRequest)retriedRequest);
                return (UpdateUserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateUserCapabilitiesResponse updateUserCapabilities(UpdateUserCapabilitiesRequest request) {
        LOG.trace("Called updateUserCapabilities");
        UpdateUserCapabilitiesRequest interceptedRequest = UpdateUserCapabilitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserCapabilitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateUserCapabilitiesResponse> transformer = UpdateUserCapabilitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateUserCapabilitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateUserCapabilitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateUserCapabilitiesDetails(), (BmcRequest)retriedRequest);
                return (UpdateUserCapabilitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateUserStateResponse updateUserState(UpdateUserStateRequest request) {
        LOG.trace("Called updateUserState");
        UpdateUserStateRequest interceptedRequest = UpdateUserStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUserStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateUserStateResponse> transformer = UpdateUserStateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateUserStateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateUserStateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStateDetails(), (BmcRequest)retriedRequest);
                return (UpdateUserStateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UploadApiKeyResponse uploadApiKey(UploadApiKeyRequest request) {
        LOG.trace("Called uploadApiKey");
        UploadApiKeyRequest interceptedRequest = UploadApiKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadApiKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UploadApiKeyResponse> transformer = UploadApiKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UploadApiKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UploadApiKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateApiKeyDetails(), (BmcRequest)retriedRequest);
                return (UploadApiKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public IdentityWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public IdentityPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IdentityClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public IdentityClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new IdentityClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

