/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.RegionSubscription;
import com.oracle.bmc.identity.requests.CreateRegionSubscriptionRequest;
import com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionSubscriptionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateRegionSubscriptionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateRegionSubscriptionRequest interceptRequest(CreateRegionSubscriptionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateRegionSubscriptionRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateRegionSubscriptionDetails(), (String)"createRegionSubscriptionDetails is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("tenancies").path(HttpUtils.encodePathSegment((String)request.getTenancyId())).path("regionSubscriptions");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateRegionSubscriptionResponse> fromResponse() {
        Function<Response, CreateRegionSubscriptionResponse> transformer = new Function<Response, CreateRegionSubscriptionResponse>(){

            public CreateRegionSubscriptionResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RegionSubscription.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateRegionSubscriptionResponse.Builder builder = CreateRegionSubscriptionResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.regionSubscription((RegionSubscription)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateRegionSubscriptionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

