/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.CreateOAuth2ClientCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateOAuthClientCredentialRequest
extends BmcRequest<CreateOAuth2ClientCredentialDetails> {
    private String userId;
    private CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails;
    private String opcRetryToken;

    @InternalSdk
    public CreateOAuth2ClientCredentialDetails getBody$() {
        return this.createOAuth2ClientCredentialDetails;
    }

    @ConstructorProperties(value={"userId", "createOAuth2ClientCredentialDetails", "opcRetryToken"})
    CreateOAuthClientCredentialRequest(String userId, CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails, String opcRetryToken) {
        this.userId = userId;
        this.createOAuth2ClientCredentialDetails = createOAuth2ClientCredentialDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public CreateOAuth2ClientCredentialDetails getCreateOAuth2ClientCredentialDetails() {
        return this.createOAuth2ClientCredentialDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOAuthClientCredentialRequest, CreateOAuth2ClientCredentialDetails> {
        private String userId;
        private CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.createOAuth2ClientCredentialDetails(o.getCreateOAuth2ClientCredentialDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOAuthClientCredentialRequest build() {
            CreateOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateOAuth2ClientCredentialDetails body) {
            this.createOAuth2ClientCredentialDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder createOAuth2ClientCredentialDetails(CreateOAuth2ClientCredentialDetails createOAuth2ClientCredentialDetails) {
            this.createOAuth2ClientCredentialDetails = createOAuth2ClientCredentialDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            return new CreateOAuthClientCredentialRequest(this.userId, this.createOAuth2ClientCredentialDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateOAuthClientCredentialRequest.Builder(userId=" + this.userId + ", createOAuth2ClientCredentialDetails=" + this.createOAuth2ClientCredentialDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

